/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.capability;

import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_Regeneration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityRegeneration
implements IRegenerationCapability {
    @CapabilityInject(value=IRegenerationCapability.class)
    public static final Capability<IRegenerationCapability> REGEN_CAP = null;
    public EntityPlayer player;
    private int regenCount;
    private int regenTicks;
    private boolean canRegen;
    public int regen_color = -30444;

    public CapabilityRegeneration(EntityPlayer p) {
        this.player = p;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("regenCount", this.regenCount);
        compound.func_74768_a("regenTicks", this.regenTicks);
        compound.func_74757_a("canRegen", this.canRegen);
        compound.func_74768_a("regenColor", this.regen_color);
        return compound;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.regenCount = nbt.func_74762_e("regenCount");
        this.regenTicks = nbt.func_74762_e("regenTicks");
        this.canRegen = nbt.func_74767_n("canRegen");
        this.regen_color = nbt.func_74762_e("regenColor");
    }

    @Override
    public void syncToPlayer() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_Regeneration(this.player));
    }

    @Override
    public void setTicksExisted(int ticks) {
        this.regenTicks = ticks;
    }

    @Override
    public void setRegenCount(int count) {
        this.regenCount = count;
    }

    @Override
    public void setCanRegen(boolean timelord) {
        this.canRegen = timelord;
    }

    @Override
    public void setColor(int color) {
        this.regen_color = color;
    }

    @Override
    public int getColor() {
        return this.regen_color;
    }

    @Override
    public boolean canPlayerRegenerate() {
        return this.canRegen;
    }

    @Override
    public int getTicksExisted() {
        return this.regenTicks;
    }

    @Override
    public int getRegenAmount() {
        return this.regenCount;
    }

    public static class Storage
    implements Capability.IStorage<IRegenerationCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<IRegenerationCapability> capability, IRegenerationCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IRegenerationCapability> capability, IRegenerationCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class CapabilityTimelordProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private IRegenerationCapability capability;

        public CapabilityTimelordProvider(IRegenerationCapability capability) {
            this.capability = capability;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return REGEN_CAP != null && capability == REGEN_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == REGEN_CAP ? REGEN_CAP.cast((Object)this.capability) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)REGEN_CAP.getStorage().writeNBT(REGEN_CAP, (Object)this.capability, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            REGEN_CAP.getStorage().readNBT(REGEN_CAP, (Object)this.capability, null, (NBTBase)nbt);
        }
    }
}

