/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.ibm.icu.text.SimpleDateFormat;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.FileUtils;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.binary.Base64;

public class DMUtils {
    public static final Random RANDOM = new Random();
    private static final String ALGORITHM = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    public static final ResourceLocation GUI_BACK_PARTS = FileUtils.newResourceLocation("thedalekmod:gui/parts.png");
    public static final ResourceLocation SYMBOL = FileUtils.newResourceLocation("thedalekmod:gui/title/shades_symbol.png");
    public static final ResourceLocation SYMBOL_2 = FileUtils.newResourceLocation("thedalekmod:gui/title/shades_symbol_2.png");

    public static String formatTimestamp(long time, String pattern) {
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String getFormattedMinecraftTime(World w) {
        Long time = w.field_73011_w.getWorldTime();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    public static void gotoWebpage(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            TheDalekMod.LOG.catching((Throwable)e);
        }
    }

    public static void setBlock(World world, int x, int y, int z, Block b) {
        world.func_175656_a(new BlockPos(x, y, z), b.func_176223_P());
    }

    public static void setBlock(World world, int x, int y, int z, Block b, int i, int j) {
        world.func_175656_a(new BlockPos(x, y, z), b.func_176203_a(i));
    }

    public static String generateHash() {
        return UUID.randomUUID().toString();
    }

    public static byte[] integersToBytes(int[] values) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (int value : values) {
            try {
                dos.writeInt(value);
            }
            catch (IOException e) {
                TheDalekMod.LOG.catching((Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    public static String encrypt(String valueToEnc) throws Exception {
        Key key = DMUtils.generateKey();
        Cipher c = Cipher.getInstance(ALGORITHM);
        c.init(1, key);
        byte[] encValue = c.doFinal(valueToEnc.getBytes());
        return Base64.encodeBase64String((byte[])encValue);
    }

    private static String decrypt(String encryptedValue) throws Exception {
        Key key = DMUtils.generateKey();
        Cipher c = Cipher.getInstance(ALGORITHM);
        c.init(2, key);
        byte[] decordedValue = Base64.decodeBase64((String)encryptedValue);
        byte[] decValue = c.doFinal(decordedValue);
        return new String(decValue);
    }

    private static Key generateKey() {
        return new SecretKeySpec(keyValue, ALGORITHM);
    }

    public static String getName(String uuid) {
        try {
            URL url = new URL("https://api.mojang.com/user/profiles/" + uuid.replaceAll("-", "") + "/names");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            line = line.replace("[\"", "");
            line = line.replace("\"]", "");
            return line;
        }
        catch (Exception ex) {
            TheDalekMod.LOG.catching((Throwable)ex);
            return null;
        }
    }

    public static String getUUIDs(String player) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + player);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            if (line != null) {
                String uuid = line.substring(7, 39);
                return uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, 32);
            }
            in.close();
        }
        catch (Exception ex) {
            TheDalekMod.LOG.catching((Throwable)ex);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPosFromArg(String s, int defaultVal) {
        int i = defaultVal;
        if (s.contains("~")) {
            int num;
            if (s.length() == 1) {
                return i;
            }
            if (s.contains("+")) {
                if (s.substring(2).length() <= 0) return i;
                try {
                    num = Integer.parseInt(s.substring(2));
                    i += num;
                }
                catch (Exception e) {
                    return i;
                }
            }
            if (s.contains("-")) {
                if (s.substring(2).length() <= 0) return i;
                try {
                    num = Integer.parseInt(s.substring(2));
                    i -= num;
                }
                catch (Exception e) {
                    return i;
                }
            }
            if (s.contains("*") || s.toLowerCase().contains("x")) {
                if (s.substring(2).length() <= 0) return i;
                try {
                    num = Integer.parseInt(s.substring(2));
                    i *= num;
                }
                catch (Exception e) {
                    return i;
                }
            }
            if (!s.contains("/")) return i;
            if (s.substring(2).length() <= 0) return i;
            try {
                num = Integer.parseInt(s.substring(2));
                i /= num;
                return i;
            }
            catch (Exception e) {
                return i;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return i;
        }
    }

    public static String blockPosToString(BlockPos p) {
        return p.func_177958_n() + " : " + p.func_177956_o() + " : " + p.func_177952_p();
    }

    @SideOnly(value=Side.CLIENT)
    public static float handleRotationFloat(EntityLivingBase living, float par2) {
        return (float)living.field_70173_aa + par2;
    }

    public static Object getElementByIndex(Map map, int index) {
        return map.get(map.keySet().toArray()[index]);
    }

    public static String getLongestString(List<String> strings) {
        String longestString = "";
        for (String string : strings) {
            if (string.length() <= longestString.length()) continue;
            longestString = string;
        }
        return longestString;
    }

    public static int getLongestStringIndex(String[] array) {
        int maxLength = 0;
        int longestString = 0;
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
            longestString = i;
        }
        return longestString;
    }

    public static int[] to1dArray(int[][] array, int w, int h) {
        int[] d1 = new int[w * h];
        int i = 0;
        for (int j = 0; j < h; ++j) {
            for (int k = 0; k < w; ++k) {
                d1[i] = array[k][j];
                ++i;
            }
        }
        return d1;
    }

    public static int[][] to2dArray(int[] array, int w, int h) {
        int[][] d1 = new int[w][h];
        int x = 0;
        int y = 0;
        for (int i = 0; i < w * h; ++i) {
            d1[x][y] = array[i];
            if (++x <= w - 1) continue;
            x = 0;
            ++y;
        }
        return d1;
    }

    public static int[] bytesToIntegers(byte[] buf) {
        int[] intArr = new int[buf.length / 4];
        int offset = 0;
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = buf[3 + offset] & 0xFF | (buf[2 + offset] & 0xFF) << 8 | (buf[1 + offset] & 0xFF) << 16 | (buf[0 + offset] & 0xFF) << 24;
            offset += 4;
        }
        return intArr;
    }

    public static String blobifyObject(Object o) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream st = new ObjectOutputStream(stream);
        st.writeObject(o);
        st.close();
        return Base64.encodeBase64String((byte[])stream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deblobifyString(String s) throws IOException, ClassNotFoundException {
        byte[] r = Base64.decodeBase64((String)s);
        ByteArrayInputStream in = new ByteArrayInputStream(r);
        ObjectInputStream is = null;
        try {
            is = new ObjectInputStream(in);
            Object object = is.readObject();
            return object;
        }
        finally {
            if (is != null) {
                is.close();
            }
            in.close();
        }
    }

    public static <T> T[] toArray(T[] t, Iterable<T> elements) {
        int i = 0;
        for (T element : elements) {
            t[i] = element;
        }
        return t;
    }

    public static boolean currentEquipmentContains(EntityPlayer player, Item item) {
        for (ItemStack entry : player.func_184214_aD()) {
            if (entry.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseInBounds(int mouseX, int mouseY, Rectangle rectangle) {
        return mouseX >= rectangle.x && mouseY >= rectangle.y && mouseX <= rectangle.x + rectangle.width && mouseY <= rectangle.y + rectangle.height;
    }

    public static File getLastFileModified(String dir, String type) {
        File fl = new File(dir);
        File[] files = fl.listFiles(file -> file.isFile() && file.getName().endsWith("." + type));
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        for (File file2 : files) {
            if (file2.lastModified() <= lastMod) continue;
            choice = file2;
            lastMod = file2.lastModified();
        }
        return choice;
    }

    public static String getFileContents(File file) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int randomRange(int min, int max) {
        int res = (int)Math.floor(Math.random() * (double)(max - min + 1)) + min;
        return res;
    }

    public static <T> MethodHandle findMethod(Class<T> clazz, String methodNames, Class<?> ... methodTypes) {
        Method method = ReflectionHelper.findMethod(clazz, null, (String)methodNames, (Class[])methodTypes);
        try {
            return MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToFindMethodException((Throwable)e);
        }
    }

    public static MethodHandle findFieldGetter(Class<?> clazz, String ... fieldNames) {
        Field field = ReflectionHelper.findField(clazz, (String[])fieldNames);
        try {
            return MethodHandles.lookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, (Exception)e);
        }
    }

    public static MethodHandle findFieldSetter(Class<?> clazz, String ... fieldNames) {
        Field field = ReflectionHelper.findField(clazz, (String[])fieldNames);
        try {
            return MethodHandles.lookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, (Exception)e);
        }
    }
}

