/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class PlayerUtils {
    public static Vec3d getLook(float pitch, float yawHead) {
        float f = MathHelper.func_76134_b((float)(-yawHead * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yawHead * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static class TARDIS {
        public static void resetPlayer(EntityPlayer player) {
            ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            capa.setInFlight(false);
            player.func_184224_h(false);
            if (player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75098_d = true;
                player.field_71075_bZ.field_75102_a = true;
                player.field_71075_bZ.field_75099_e = true;
                player.func_71016_p();
                player.func_184226_ay();
            }
            if (player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75098_d = false;
                player.field_71075_bZ.field_75102_a = true;
                player.field_71075_bZ.field_75100_b = true;
                player.field_71075_bZ.field_75099_e = true;
                player.func_71016_p();
                player.func_184226_ay();
            }
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75098_d = false;
                player.field_71075_bZ.field_75102_a = false;
                player.field_71075_bZ.field_75100_b = false;
                player.field_71075_bZ.field_75099_e = true;
                player.field_70160_al = false;
                player.func_71016_p();
                player.func_184226_ay();
            }
            player.eyeHeight = 1.62f;
            player.func_82142_c(false);
            player.func_71016_p();
        }
    }

    public static class Auth {
        public static boolean doUUIDsMatch(EntityPlayer player, String ... uuid) {
            String playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
            for (String s : uuid) {
                if (!playerUUID.contains(s)) continue;
                return playerUUID.contains(s);
            }
            return false;
        }

        public static String getName(UUID uuid) {
            return DMUtils.getName(uuid.toString());
        }

        public static String getPlayerUUID(EntityPlayer player) {
            return player.func_146103_bH().getId().toString();
        }

        public static String getUUID(String player) {
            String strUUID = DMUtils.getUUIDs(player);
            return strUUID;
        }
    }

    public static class Messaging {
        public static void sendMessageToPlayer(EntityPlayer p, String s) {
            if (!p.field_70170_p.field_72995_K) {
                TextComponentString textComponent = new TextComponentString(s);
                p.func_145747_a((ITextComponent)textComponent);
            }
        }

        public static void sendMessageToPlayer(EntityPlayer p, EnumDefaultResponse s) {
            TextComponentTranslation textComponent = new TextComponentTranslation(s.name, new Object[0]);
            p.func_145747_a((ITextComponent)textComponent);
        }

        public static void sendStatusMessageToPlayer(EntityPlayer p, String message, boolean actionBar) {
            TextComponentString textComponent = new TextComponentString(message);
            p.func_146105_b((ITextComponent)textComponent, actionBar);
        }
    }

    public static class Hands {
        public static boolean isInHand(EnumHand hand, EntityPlayer holder, ItemStack item) {
            if (!holder.func_184586_b(hand).func_190926_b()) {
                ItemStack heldItem = holder.func_184586_b(hand);
                return heldItem.func_77969_a(item);
            }
            return false;
        }

        public static boolean isInMainHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.MAIN_HAND, holder, new ItemStack(item));
        }

        public static boolean isInOffHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.OFF_HAND, holder, new ItemStack(item));
        }

        public static boolean isInEitherHand(EntityPlayer holder, Item item) {
            return Hands.isInMainHand(holder, item) || Hands.isInOffHand(holder, item);
        }

        public static boolean isInOneHand(EntityPlayer holder, Item item) {
            boolean mainHand = Hands.isInMainHand(holder, item) && !Hands.isInOffHand(holder, item);
            boolean offHand = Hands.isInOffHand(holder, item) && !Hands.isInMainHand(holder, item);
            return mainHand || offHand;
        }
    }
}

