/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.model.mdl;

import com.swdteam.client.init.DMFontRenderer;
import com.swdteam.client.model.mdl.MDLData;
import com.swdteam.client.model.mdl.MDLState;
import com.swdteam.client.model.mdl.ModelRendererPatch;
import com.swdteam.client.render.IRenderExtender;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.obj.Obj;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelMDL
extends ModelBase {
    private BufferedImage texture;
    private BufferedImage textureLM;
    private Obj objmodel;
    private int textureID;
    private int textureIDLM;
    private boolean loadingTexture;
    private List<ModelRendererPatch> parts = new ArrayList<ModelRendererPatch>();
    private boolean useTexture;
    private MDLData model_data;
    private IRenderExtender renderExtender;

    public void renderModel(TileEntity t, float ... f) {
        this.renderModel(MDLState.DEFAULT, t, f);
    }

    public void renderModel(float ... scale) {
        this.renderModel(MDLState.DEFAULT, null, scale);
    }

    public void renderModel(MDLState state, TileEntity t, float ... f) {
        FloatBuffer color = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)color);
        float alphaValue = color.get(3);
        float rValue = color.get(0);
        float gValue = color.get(1);
        float bValue = color.get(2);
        int oldBrightX = (int)OpenGlHelper.lastBrightnessX;
        int oldBrightY = (int)OpenGlHelper.lastBrightnessY;
        int bright = 240;
        int brightX = bright % 65536;
        int brightY = bright / 65536;
        int previousTexture = GL11.glGetInteger((int)32873);
        float master_scale = this.model_data.master_scale;
        double tx = this.model_data.transform[0] * (double)master_scale;
        double ty = this.model_data.transform[1] * (double)master_scale;
        double tz = this.model_data.transform[2] * (double)master_scale;
        double ox = this.model_data.offset[0] * (double)master_scale;
        double oy = this.model_data.offset[1] * (double)master_scale;
        double oz = this.model_data.offset[2] * (double)master_scale;
        double rx = this.model_data.rotation[0];
        double ry = this.model_data.rotation[1];
        double rz = this.model_data.rotation[2];
        double sx = this.model_data.scale[0];
        double sy = this.model_data.scale[1];
        double sz = this.model_data.scale[2];
        GlStateManager.func_179094_E();
        if (this.parts != null) {
            boolean enabled = GL11.glIsEnabled((int)3042);
            if (!enabled) {
                GL11.glEnable((int)3042);
            }
            GL11.glBlendFunc((int)770, (int)771);
            if (this.model_data != null) {
                GlStateManager.func_179137_b((double)tx, (double)ty, (double)tz);
                GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
                GL11.glScaled((double)sx, (double)sy, (double)sz);
                GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                GL11.glRotated((double)rx, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)ry, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rz, (double)0.0, (double)0.0, (double)1.0);
                GlStateManager.func_179137_b((double)ox, (double)oy, (double)oz);
            }
            for (ModelRendererPatch p : this.parts) {
                p.field_78800_c = p.default_position[0];
                p.field_78797_d = p.default_position[1];
                p.field_78798_e = p.default_position[2];
                p.field_78795_f = (float)Math.toRadians(p.default_rotation[0]);
                p.field_78796_g = (float)Math.toRadians(p.default_rotation[1]);
                p.field_78808_h = (float)Math.toRadians(p.default_rotation[2]);
                p.field_82906_o = p.default_offset[0];
                p.field_82908_p = p.default_offset[1];
                p.field_82907_q = p.default_offset[2];
                p.func_78784_a(p.default_texture_offset[0], p.default_texture_offset[1]);
                this.defaultChildElements(p);
            }
            for (int i = 0; i < this.model_data.model_states.length; ++i) {
                MDLData.MDLStates s = this.model_data.model_states[i];
                if (!s.state.name.equalsIgnoreCase(state.name)) continue;
                for (ModelRendererPatch p : this.parts) {
                    if (p.getShapeName().equals(s.shape_name)) {
                        if (s.state_position != null) {
                            p.field_78800_c = s.state_position[0];
                            p.field_78797_d = s.state_position[1];
                            p.field_78798_e = s.state_position[2];
                        }
                        if (s.state_rotation != null) {
                            p.field_78795_f = (float)Math.toRadians(s.state_rotation[0]);
                            p.field_78796_g = (float)Math.toRadians(s.state_rotation[1]);
                            p.field_78808_h = (float)Math.toRadians(s.state_rotation[2]);
                        }
                        if (s.state_offset != null) {
                            p.field_82906_o = s.state_offset[0];
                            p.field_82908_p = s.state_offset[1];
                            p.field_82907_q = s.state_offset[2];
                        }
                        if (s.state_texture_offset != null) {
                            p.func_78784_a(s.state_texture_offset[0], s.state_texture_offset[1]);
                        }
                    }
                    this.checkChildElementsForStates(this.model_data, p, s);
                }
            }
            if (this.useTexture && this.texture != null) {
                if (!this.loadingTexture) {
                    this.loadingTexture = true;
                    if (this.texture != null) {
                        this.textureID = Graphics.loadTexture(this.texture);
                    }
                    if (this.textureLM != null) {
                        this.textureIDLM = Graphics.loadTexture(this.textureLM);
                    }
                }
                Graphics.bindTexture(this.textureID);
            }
            if (this.objmodel != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                GlStateManager.func_179144_i((int)1);
                this.objmodel.renderAll();
                GlStateManager.func_179121_F();
            }
            for (ModelRendererPatch r : this.parts) {
                r.func_78791_b(f[0]);
            }
            if (this.useTexture && this.textureLM != null && this.model_data.lightmap) {
                if (!this.loadingTexture) {
                    this.loadingTexture = true;
                    if (this.textureLM != null) {
                        this.textureIDLM = Graphics.loadTexture(this.textureLM);
                    }
                }
                Graphics.bindTexture(this.textureIDLM);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightX, (float)brightY);
                GlStateManager.func_179140_f();
                for (ModelRendererPatch r : this.parts) {
                    r.func_78791_b(f[0]);
                }
                if (this.objmodel != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    GlStateManager.func_179144_i((int)1);
                    this.objmodel.renderAll();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179145_e();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldBrightX, (float)oldBrightY);
            }
            if (!enabled) {
                GL11.glDisable((int)3042);
            }
            if (this.useTexture) {
                // empty if block
            }
        }
        if (this.model_data != null && this.model_data.font_renderer != null) {
            for (int i = 0; i < this.model_data.font_renderer.length; ++i) {
                MDLData.MDLTextData d = this.model_data.font_renderer[i];
                if (d == null) continue;
                float scaletext = 1.0f / DMFontRenderer.getStringWidth(d.getText());
                scaletext = d.auto_scale ? 1.0f / DMFontRenderer.getStringWidth(d.getText()) : 0.015625f;
                double ftx = d.transform[0] * (double)master_scale;
                double fty = d.transform[1] * (double)master_scale;
                double ftz = d.transform[2] * (double)master_scale;
                double fox = d.offset[0] * (double)master_scale;
                double foy = d.offset[1] * (double)master_scale;
                double foz = d.offset[2] * (double)master_scale;
                double frx = d.rotation[0];
                double fry = d.rotation[1];
                double frz = d.rotation[2];
                double fsx = d.scale[0];
                double fsy = d.scale[1];
                double fsz = d.scale[2];
                int stack = d.stack;
                if (d.stack < 1) {
                    stack = 1;
                }
                GlStateManager.func_179094_E();
                for (int j = 0; j < stack; ++j) {
                    GlStateManager.func_179094_E();
                    GL11.glRotated((double)(360 * j / d.stack), (double)0.0, (double)1.0, (double)0.0);
                    GlStateManager.func_179137_b((double)ftx, (double)fty, (double)ftz);
                    GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    GL11.glRotated((double)frx, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)fry, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)frz, (double)0.0, (double)0.0, (double)1.0);
                    GlStateManager.func_179137_b((double)fox, (double)foy, (double)foz);
                    GL11.glScaled((double)(fsx * (double)scaletext), (double)(fsy * (double)scaletext), (double)(fsz * (double)scaletext));
                    float[] colorValues = (float[])d.color_rgba.clone();
                    if (colorValues.length <= 3) {
                        colorValues = new float[]{d.color_rgba[0], d.color_rgba[1], d.color_rgba[2], 1.0f};
                    }
                    if (colorValues.length > 3) {
                        colorValues[3] = alphaValue;
                        if (colorValues[3] < 0.0f) {
                            colorValues[3] = 0.0f;
                        }
                    }
                    if (d.glow) {
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightX, (float)brightY);
                    } else {
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldBrightX, (float)oldBrightY);
                    }
                    if (d.getText().toString().endsWith(".auto")) {
                        if (d.getText().toString().equals("PoliceBox.auto")) {
                            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                            DMFontRenderer.drawCenteredMiddleString("POLICE     BOX", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)8.5f, (float)0.5f, (float)0.0f);
                            GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
                            DMFontRenderer.drawCenteredTopString("PUBLIC", 0.0f, 0.0f, colorValues);
                            DMFontRenderer.drawCenteredString("CALL", 0.0f, 0.0f, colorValues);
                        }
                        if (d.getText().toString().equals("PullToOpen.auto")) {
                            GlStateManager.func_179152_a((float)0.6f, (float)0.57f, (float)1.0f);
                            GlStateManager.func_179152_a((float)1.4f, (float)1.0f, (float)1.0f);
                            DMFontRenderer.drawCenteredString("POLICE TELEPHONE", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179152_a((float)1.2f, (float)1.5f, (float)1.0f);
                            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                            DMFontRenderer.drawCenteredString("FREE", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
                            GlStateManager.func_179152_a((float)0.6666667f, (float)0.6666667f, (float)1.0f);
                            DMFontRenderer.drawCenteredString("FOR USE OF", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                            GlStateManager.func_179109_b((float)0.0f, (float)9.0f, (float)0.0f);
                            DMFontRenderer.drawCenteredString("PUBLIC", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)16.0f, (float)0.0f);
                            GlStateManager.func_179152_a((float)0.6666667f, (float)0.6666667f, (float)1.0f);
                            GlStateManager.func_179152_a((float)0.9090909f, (float)1.0f, (float)1.0f);
                            DMFontRenderer.drawCenteredString("ADVICE & ASSISTANCE", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                            DMFontRenderer.drawCenteredString("OBTAINABLE IMMEDIATELY", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)18.0f, (float)0.0f);
                            GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
                            DMFontRenderer.drawCenteredString("OFFICERS & CARS", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                            DMFontRenderer.drawCenteredString("RESPOND TO ALL CALLS", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179152_a((float)1.1111112f, (float)1.1111112f, (float)1.1111112f);
                            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                            GlStateManager.func_179109_b((float)0.0f, (float)11.0f, (float)0.0f);
                            GlStateManager.func_179152_a((float)1.26f, (float)1.1f, (float)1.0f);
                            DMFontRenderer.drawCenteredString("PULL TO OPEN", 0.0f, 0.0f, colorValues);
                            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                        }
                    } else if (d.center_text) {
                        if (d.center.equals("center_bottom") || d.center.equals("")) {
                            DMFontRenderer.drawCenteredString(d.getText(), 0.0f, 0.0f, colorValues);
                        } else if (d.center.equals("center_middle")) {
                            GlStateManager.func_179109_b((float)0.0f, (float)-0.35f, (float)0.0f);
                            DMFontRenderer.drawCenteredMiddleString(d.getText(), 0.0f, 0.0f, colorValues);
                        } else if (d.center.equals("center_top") || d.center.equals("")) {
                            DMFontRenderer.drawCenteredTopString(d.getText(), 0.0f, 0.0f, colorValues);
                        }
                    } else {
                        DMFontRenderer.drawString(d.getText(), 0.0f, 0.0f, colorValues);
                    }
                    GlStateManager.func_179121_F();
                }
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldBrightX, (float)oldBrightY);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)rValue, (float)gValue, (float)bValue, (float)alphaValue);
        }
        Graphics.bindTexture(previousTexture);
        GlStateManager.func_179121_F();
    }

    public void checkChildElementsForStates(MDLData data, ModelRendererPatch mr, MDLData.MDLStates s) {
        if (mr.field_78805_m != null) {
            for (Object o : mr.field_78805_m) {
                if (!(o instanceof ModelRendererPatch)) continue;
                ModelRendererPatch p = (ModelRendererPatch)((Object)o);
                if (p.getShapeName().equals(s.shape_name)) {
                    p.field_78800_c = s.state_offset[0];
                    p.field_78797_d = s.state_offset[1];
                    p.field_78798_e = s.state_offset[2];
                    p.field_78795_f = s.state_rotation[0];
                    p.field_78796_g = s.state_rotation[1];
                    p.field_78808_h = s.state_rotation[2];
                    p.field_82906_o = s.state_position[0];
                    p.field_82908_p = s.state_position[1];
                    p.field_82907_q = s.state_position[2];
                    p.func_78784_a(s.state_texture_offset[0], s.state_texture_offset[1]);
                }
                this.checkChildElementsForStates(data, p, s);
            }
        }
    }

    public void defaultChildElements(ModelRenderer m) {
        if (m.field_78805_m != null && m.field_78805_m.size() > 0) {
            for (Object j : m.field_78805_m) {
                if (j instanceof ModelRendererPatch) {
                    ModelRendererPatch p = (ModelRendererPatch)((Object)j);
                    p.field_78800_c = p.default_position[0];
                    p.field_78797_d = p.default_position[1];
                    p.field_78798_e = p.default_position[2];
                    p.field_78795_f = (float)Math.toRadians(p.default_rotation[0]);
                    p.field_78796_g = (float)Math.toRadians(p.default_rotation[1]);
                    p.field_78808_h = (float)Math.toRadians(p.default_rotation[2]);
                    p.field_82906_o = p.default_offset[0];
                    p.field_82908_p = p.default_offset[1];
                    p.field_82907_q = p.default_offset[2];
                    p.func_78784_a(p.default_texture_offset[0], p.default_texture_offset[1]);
                }
                this.defaultChildElements((ModelRenderer)j);
            }
        }
    }

    public int getTextureID() {
        return this.textureID;
    }

    public int getTextureIDLM() {
        return this.textureIDLM;
    }

    public void setTextureID(int id) {
        this.textureID = id;
    }

    public void setTextureIDLM(int id) {
        this.textureIDLM = id;
    }

    public void setTexture(BufferedImage texture) {
        this.texture = texture;
    }

    public void setLightMaptexture(BufferedImage texture) {
        this.textureLM = texture;
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public void setObjModel(Obj obj) {
        this.objmodel = obj;
    }

    public Obj getObjModel() {
        return this.objmodel;
    }

    public BufferedImage getTextureLM() {
        return this.textureLM;
    }

    public List<ModelRendererPatch> getParts() {
        return this.parts;
    }

    public void addPart(ModelRendererPatch r) {
        this.parts.add(r);
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78088_a(Entity p_78088_1_, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float p_78088_7_) {
        if (this.getRenderExtender() != null) {
            this.getRenderExtender().preRender(p_78088_1_, 0);
        }
        this.renderModel(null, p_78088_7_);
        if (this.getRenderExtender() != null) {
            this.getRenderExtender().postRender(p_78088_1_, 0);
        }
        super.func_78088_a(p_78088_1_, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, p_78088_7_);
    }

    public boolean canUseTexture() {
        return this.useTexture;
    }

    public void setUseTexture(boolean useTexture) {
        this.useTexture = useTexture;
    }

    public void setRenderExtender(IRenderExtender renderExtender) {
        this.renderExtender = renderExtender;
    }

    public IRenderExtender getRenderExtender() {
        return this.renderExtender;
    }

    public void setModelData(MDLData model_data) {
        this.model_data = model_data;
    }

    public MDLData getModelData() {
        return this.model_data;
    }
}

