/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity.dalek;

import com.swdteam.common.entity.DMEntityUtils;
import com.swdteam.common.entity.ai.DalekLaserAttack;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.entity.dalek.IRideAble;
import com.swdteam.common.entity.vehicles.EntityDavrosChair;
import com.swdteam.common.init.DMDalekRegistry;
import com.swdteam.common.init.DMItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityDalek
extends EntityMob
implements IRangedAttackMob {
    public static final DataParameter<Integer> DALEK_TYPE = EntityDataManager.func_187226_a(EntityDalek.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DALEK_EXTRA_DATA = EntityDataManager.func_187226_a(EntityDalek.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDalek(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.8f, 1.8f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3, 30));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DalekLaserAttack(this, 0.35, 10, 20, 2.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, input -> !(input instanceof EntityDavrosChair) && !input.func_184218_aH() && !(input instanceof EntityDalek) && !(input instanceof IRideAble)));
    }

    public IDalek getDalekData() {
        IDalek dalek = null;
        int id = (Integer)this.func_184212_Q().func_187225_a(DALEK_TYPE);
        dalek = id >= DMDalekRegistry.getDaleks().size() || id < 0 ? DMDalekRegistry.DEFAULT : DMDalekRegistry.getDaleks().get(id);
        if (dalek == null) {
            dalek = DMDalekRegistry.DEFAULT;
        }
        return dalek;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.getDalekData().getHurtSound((Entity)this);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.getDalekData().getLivingSound((Entity)this);
    }

    protected SoundEvent func_184615_bR() {
        return this.getDalekData().getDeathSound((Entity)this);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getDalekData().getName();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        int idToUse = DMDalekRegistry.getDaleks().size() > 0 ? this.field_70170_p.field_73012_v.nextInt(DMDalekRegistry.getDaleks().size()) : 0;
        this.func_184212_Q().func_187214_a(DALEK_TYPE, (Object)idToUse);
        this.func_184212_Q().func_187214_a(DALEK_EXTRA_DATA, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("dalek_id", ((Integer)this.func_184212_Q().func_187225_a(DALEK_TYPE)).intValue());
        nbt.func_74768_a("extra_data", ((Integer)this.func_184212_Q().func_187225_a(DALEK_EXTRA_DATA)).intValue());
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(DMItems.iAMMO, this.func_70681_au().nextInt(3));
        this.func_145779_a(DMItems.dlknug, this.func_70681_au().nextInt(5));
        DMEntityUtils.dropRareItem((EntityLiving)this, DMItems.iCircuit, 20, 2);
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("dalek_id")) {
            this.setDalekID(nbt.func_74762_e("dalek_id"));
        } else {
            this.setDalekID(0);
        }
        if (nbt.func_74764_b("extra_data")) {
            this.func_184212_Q().func_187227_b(DALEK_EXTRA_DATA, (Object)nbt.func_74762_e("extra_data"));
        } else {
            this.func_184212_Q().func_187227_b(DALEK_EXTRA_DATA, (Object)0);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getDalekData().onUpdate((Entity)this);
    }

    public void func_70645_a(DamageSource damageSource) {
        this.getDalekData().onDeath((Entity)this);
        super.func_70645_a(damageSource);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        this.getDalekData().onAttacked((Entity)this, damageSource.func_76346_g(), damageSource);
        if (damageSource.func_76346_g() != null) {
            this.func_70625_a(damageSource.func_76346_g(), 1.0f, 1.0f);
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187602_cF, this.func_184176_by(), 1.0f, 1.0f, false);
        return super.func_70097_a(damageSource, amount);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)1.2f);
    }

    public void func_82196_d(EntityLivingBase living, float distanceFactor) {
        this.getDalekData().onLaserAttack(this, living, distanceFactor);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public void setDalekID(int id) {
        this.func_184212_Q().func_187227_b(DALEK_TYPE, (Object)id);
    }

    public void setupDalek() {
        this.getDalekData().setupDalek((Entity)this);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public static enum DalekFactions {
        IMPERIAL,
        RENEGADE;

    }
}

