/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.render.tileentity.dimgateway;

import com.swdteam.client.render.tileentity.dimgateway.Quaternion;
import java.util.HashMap;
import javax.vecmath.Matrix3f;
import net.minecraft.util.EnumFacing;

public class QuaternionFormula {
    public static final Quaternion NO_ROTATION_QUAT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public static final QuaternionFormula NO_ROTATION = new QuaternionFormula(NO_ROTATION_QUAT, NO_ROTATION_QUAT);
    public static final float[] NO_ROTATION_FLOAT = new float[]{0.0f, 0.0f, 0.0f};
    public static final HashMap<Float, Quaternion> horizontalQuats = new HashMap();
    public static final HashMap<Float, Quaternion> verticalQuats = new HashMap();
    public Quaternion qHI;
    public Quaternion conjQHI;
    public Quaternion qHO;
    public Quaternion conjQHO;
    public Quaternion qVI;
    public Quaternion conjQVI;
    public Quaternion qVO;
    public Quaternion conjQVO;
    public boolean noRotation;

    public static Quaternion getHorizontalQuaternion(EnumFacing in) {
        float horiAngle = in.func_185119_l() - 0.0125f;
        Quaternion quat = horizontalQuats.get(Float.valueOf(horiAngle));
        if (quat == null) {
            quat = QuaternionFormula.createQuaternionFromZXYEuler(0.0f, horiAngle, 0.0f);
            horizontalQuats.put(Float.valueOf(horiAngle), quat);
        }
        return quat;
    }

    public static Quaternion getVerticalQuaternion(EnumFacing in) {
        float vertAngle = (float)in.func_96559_d() * 90.0f * 0.99f;
        Quaternion quat = verticalQuats.get(Float.valueOf(vertAngle));
        if (quat == null) {
            quat = QuaternionFormula.createQuaternionFromZXYEuler(vertAngle, 0.0f, 0.0f);
            verticalQuats.put(Float.valueOf(vertAngle), quat);
        }
        return quat;
    }

    public QuaternionFormula(Quaternion inH, Quaternion outH) {
        this.qHI = inH;
        this.conjQHI = this.qHI.conjugate();
        this.qHO = outH;
        this.conjQHO = this.qHO.conjugate();
        this.qVI = this.qVO = NO_ROTATION_QUAT;
        this.conjQVI = this.conjQVO = NO_ROTATION_QUAT.conjugate();
        this.noRotation = QuaternionFormula.quaternionsIdentical(this.qHI, this.qHO);
    }

    public QuaternionFormula(Quaternion inH, Quaternion outH, Quaternion inV, Quaternion outV) {
        this(inH, outH);
        this.qVI = inV;
        this.conjQVI = this.qVI.conjugate();
        this.qVO = outV;
        this.conjQVO = this.qVO.conjugate();
        this.noRotation = QuaternionFormula.quaternionsIdentical(this.qVI, this.qVO) && this.noRotation;
    }

    public static QuaternionFormula createFromFaces(EnumFacing in, EnumFacing inUp, EnumFacing out, EnumFacing outUp) {
        if (in.func_176740_k().func_176720_b() || out.func_176740_k().func_176720_b()) {
            return new QuaternionFormula(QuaternionFormula.getHorizontalQuaternion(in.func_176740_k().func_176720_b() ? inUp : in), QuaternionFormula.getHorizontalQuaternion(out.func_176740_k().func_176720_b() ? outUp : out), QuaternionFormula.getVerticalQuaternion(in), QuaternionFormula.getVerticalQuaternion(out));
        }
        return new QuaternionFormula(QuaternionFormula.getHorizontalQuaternion(in), QuaternionFormula.getHorizontalQuaternion(out));
    }

    public static QuaternionFormula createFromPlanes(EnumFacing in, EnumFacing inUp, EnumFacing out, EnumFacing outUp) {
        return QuaternionFormula.createFromFaces(in.func_176734_d(), in == EnumFacing.UP ? inUp : inUp.func_176734_d(), out, out == EnumFacing.DOWN ? outUp : outUp.func_176734_d());
    }

    public float[] applyPositionalRotation(float[] ori) {
        if (this.noRotation) {
            return ori;
        }
        float[] applied = new float[3];
        Quaternion qPos = new Quaternion(ori[0], ori[1], ori[2], 0.0f);
        qPos = this.qHI.mul(qPos).mul(this.conjQHI);
        qPos = this.qVI.mul(qPos).mul(this.conjQVI);
        qPos = this.conjQVO.mul(qPos).mul(this.qVO);
        qPos = this.conjQHO.mul(qPos).mul(this.qHO);
        applied[0] = qPos.x;
        applied[1] = qPos.y;
        applied[2] = qPos.z;
        return applied;
    }

    public float[] applyRotationalRotation(float[] ori) {
        if (this.noRotation) {
            return NO_ROTATION_FLOAT;
        }
        Quaternion qRot = QuaternionFormula.createQuaternionFromZXYEuler(ori[1], ori[0], ori[2]);
        qRot = qRot.mul(this.conjQHI);
        if (!QuaternionFormula.quaternionsIdentical(this.qVI, NO_ROTATION_QUAT)) {
            qRot = qRot.mul(this.qVI);
        }
        if (!QuaternionFormula.quaternionsIdentical(this.qVO, NO_ROTATION_QUAT)) {
            qRot = qRot.mul(this.conjQVO);
        }
        qRot = qRot.mul(this.qHO);
        float[] angles = QuaternionFormula.createZXYEulerFromQuaternion(qRot);
        return new float[]{angles[1] - ori[0], angles[0] - ori[1], angles[2] - ori[2]};
    }

    public static Quaternion createQuaternionFromZXYEuler(float x, float y, float z) {
        double radX = Math.toRadians(x);
        double radY = Math.toRadians(y);
        double radZ = Math.toRadians(z);
        float cx = (float)Math.cos(radX);
        float sx = (float)Math.sin(radX);
        float cy = (float)Math.cos(radY);
        float sy = (float)Math.sin(radY);
        float cz = (float)Math.cos(radZ);
        float sz = (float)Math.sin(radZ);
        return new Quaternion().setFromMatrix(new Matrix3f(new float[]{cy * cz - sx * sy * sz, -cx * sz, cz * sy + cy * sx * sz, cz * sx * sy + cy * sz, cx * cz, -cy * cz * sx + sy * sz, -cx * sy, sx, cx * cy}));
    }

    public static float[] createZXYEulerFromQuaternion(Quaternion q) {
        double thetaY;
        double thetaZ;
        double thetaX;
        float xx = q.x * q.x;
        float xy = q.x * q.y;
        float xz = q.x * q.z;
        float xw = q.x * q.w;
        float yy = q.y * q.y;
        float yz = q.y * q.z;
        float yw = q.y * q.w;
        float zz = q.z * q.z;
        float zw = q.z * q.w;
        Matrix3f matrix = new Matrix3f(new float[]{1.0f - 2.0f * (yy + zz), 2.0f * (xy - zw), 2.0f * (xz + yw), 2.0f * (xy + zw), 1.0f - 2.0f * (xx + zz), 2.0f * (yz - xw), 2.0f * (xz - yw), 2.0f * (yz + xw), 1.0f - 2.0f * (xx + yy)});
        if (matrix.m21 < 1.0f) {
            if (matrix.m21 > -1.0f) {
                thetaX = Math.asin(matrix.m21);
                thetaZ = Math.atan2(-matrix.m01, matrix.m11);
                thetaY = Math.atan2(-matrix.m20, matrix.m22);
            } else {
                thetaX = -1.5707963267948966;
                thetaZ = -Math.atan2(matrix.m02, matrix.m00);
                thetaY = 0.0;
            }
        } else {
            thetaX = 1.5707963267948966;
            thetaZ = Math.atan2(matrix.m02, matrix.m00);
            thetaY = 0.0;
        }
        float[] angles = new float[]{(float)Math.toDegrees(thetaX), (float)Math.toDegrees(thetaY), (float)Math.toDegrees(thetaZ)};
        return angles;
    }

    public static boolean quaternionsIdentical(Quaternion a, Quaternion b) {
        return a.x == b.x && a.y == b.y && a.z == b.z && a.w == b.w;
    }
}

