/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.capability;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.ITimelordCapability;
import com.swdteam.common.custom_events.EventRegeneration;
import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSoundEvents;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.MessageSyncTimelordCap;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Utils;
import com.swdteam.utils.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TimelordCapability
implements ITimelordCapability {
    @CapabilityInject(value=ITimelordCapability.class)
    public static final Capability<ITimelordCapability> TIMELORD_CAP = null;
    public EntityPlayer player;
    public int regenCount;
    public int regenTicks;
    public boolean isTimelord;

    public TimelordCapability(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("regenCount", this.regenCount);
        compound.func_74768_a("regenTicks", this.regenTicks);
        compound.func_74757_a("isTimelord", this.isTimelord);
        return compound;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.regenCount = nbt.func_74762_e("regenCount");
        this.regenTicks = nbt.func_74762_e("regenTicks");
        this.isTimelord = nbt.func_74767_n("isTimelord");
    }

    @Override
    public void syncToPlayer() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncTimelordCap(this.player));
    }

    @Override
    public boolean isTimelord() {
        return this.isTimelord;
    }

    @Override
    public int getRegenTicks() {
        return this.regenTicks;
    }

    @Override
    public int getRegenCount() {
        return this.regenCount;
    }

    @Override
    public void setRegenTicks(int ticks) {
        this.regenTicks = ticks;
    }

    @Override
    public void setRegenCount(int count) {
        this.regenCount = count;
    }

    @Override
    public void setTimelord(boolean timelord) {
        this.isTimelord = timelord;
    }

    public static class Storage
    implements Capability.IStorage<ITimelordCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<ITimelordCapability> capability, ITimelordCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ITimelordCapability> capability, ITimelordCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(TIMELORD_CAP, null)) {
                return;
            }
            event.addCapability(new ResourceLocation("thedalekmod", "regeneration"), (ICapabilityProvider)new CapabilityTimelordProvider(new TimelordCapability((EntityPlayer)event.getObject())));
        }

        @SubscribeEvent
        public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
            if (event.getTarget().hasCapability(TIMELORD_CAP, null)) {
                ((ITimelordCapability)event.getTarget().getCapability(TIMELORD_CAP, null)).syncToPlayer();
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone event) {
            NBTTagCompound nbt = (NBTTagCompound)TIMELORD_CAP.getStorage().writeNBT(TIMELORD_CAP, event.getOriginal().getCapability(TIMELORD_CAP, null), null);
            TIMELORD_CAP.getStorage().readNBT(TIMELORD_CAP, event.getEntityPlayer().getCapability(TIMELORD_CAP, null), null, (NBTBase)nbt);
        }

        @SubscribeEvent
        public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntity() instanceof EntityPlayer && event.getEntity().hasCapability(TIMELORD_CAP, null) && ((ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null)).isTimelord()) {
                ITimelordCapability capability = (ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null);
                EntityPlayer player = (EntityPlayer)event.getEntity();
                if (capability.getRegenTicks() > 0) {
                    if (player.field_70170_p.field_73011_w instanceof WorldProviderTardis && capability.getRegenTicks() == 1) {
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSoundEvents.CloisterBell, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        int tardisID = PersistantDataManager.getInt((Entity)player, "last_tardis_ID");
                        TardisData data = DMTardis.getTardis(tardisID);
                        if (data != null && data.isInFlight()) {
                            data.setTardisDimensionLocation(Utils.RANDOM.nextInt(DimensionManager.getStaticDimensionIDs().length));
                            if (data.getTardisDimensionLocation() == DMDimensions.DIM_TARDIS_ID || !DimensionManager.isDimensionRegistered((int)data.getTardisDimensionLocation())) {
                                data.setTardisDimensionLocation(0);
                            }
                            Vector3 vec = new Vector3(Utils.RANDOM.nextInt(7001), Utils.RANDOM.nextInt(100), Utils.RANDOM.nextInt(7001));
                            data.setTravelToLocation(vec);
                            ActionList.flyTardisDematRemat((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (EntityPlayer)player, (boolean)true);
                        }
                    }
                    capability.setRegenTicks(capability.getRegenTicks() + 1);
                    capability.syncToPlayer();
                    if (!player.field_70170_p.field_72995_K && capability.getRegenTicks() > 100) {
                        player.func_70066_B();
                        if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() instanceof BlockFire) {
                            player.field_70170_p.func_175698_g(player.func_180425_c());
                        }
                        double x = player.field_70165_t + player.func_70681_au().nextGaussian() * 2.0;
                        double y = player.field_70163_u + 0.5 + player.func_70681_au().nextGaussian() * 2.0;
                        double z = player.field_70161_v + player.func_70681_au().nextGaussian() * 2.0;
                        player.field_70170_p.func_72885_a((Entity)player, x, y, z, 1.0f, true, false);
                    }
                }
                if (capability.getRegenTicks() > 200) {
                    capability.setRegenTicks(0);
                    player.func_70606_j(player.func_110138_aP());
                    player.func_70674_bp();
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 3600, 3, false, false));
                    capability.setRegenCount(capability.getRegenCount() + 1);
                    player.func_184224_h(false);
                }
            }
        }

        @SubscribeEvent
        public void onAttacked(LivingAttackEvent event) {
            if (event.getEntity() instanceof EntityPlayer && event.getEntity().hasCapability(TIMELORD_CAP, null) && ((ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null)).isTimelord()) {
                ITimelordCapability capability = (ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null);
                if ((event.getSource().func_94541_c() || event.getSource().func_76347_k()) && capability.getRegenTicks() >= 100) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public void onDeath(LivingDeathEvent event) {
            if (event.getEntity() instanceof EntityPlayer && event.getEntity().hasCapability(TIMELORD_CAP, null) && ((ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null)).isTimelord()) {
                ITimelordCapability capability = (ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null);
                capability.setRegenTicks(0);
            }
        }

        @SubscribeEvent
        public void onHurt(LivingHurtEvent event) {
            if (event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                if (event.getEntity().hasCapability(TIMELORD_CAP, null) && ((ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null)).isTimelord()) {
                    ITimelordCapability capability = (ITimelordCapability)event.getEntity().getCapability(TIMELORD_CAP, null);
                    if (player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                        if (capability.getRegenCount() < 12 && capability.getRegenTicks() == 0) {
                            MinecraftForge.EVENT_BUS.post((Event)new EventRegeneration(player, capability));
                            SoundEvent[] RegenSounds = new SoundEvent[]{DMSoundEvents.Reg_1, DMSoundEvents.Reg_2};
                            SoundEvent Sound = RegenSounds[player.field_70170_p.field_73012_v.nextInt(RegenSounds.length)];
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, Sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            player.func_184224_h(true);
                            event.setCanceled(true);
                            player.func_70606_j(1.5f);
                            player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 200, 1, false, false));
                            if (capability.getRegenTicks() == 0) {
                                capability.setRegenTicks(1);
                            }
                            String time = "" + (capability.getRegenCount() + 1);
                            switch (capability.getRegenCount() + 1) {
                                case 1: {
                                    time = time + "st";
                                    break;
                                }
                                case 2: {
                                    time = time + "nd";
                                    break;
                                }
                                case 3: {
                                    time = time + "rd";
                                    break;
                                }
                                default: {
                                    time = time + "th";
                                }
                            }
                            player.func_146105_b((ITextComponent)new TextComponentString("You're regenerating for the " + time + " time, you have " + (11 - capability.getRegenCount()) + " regenerations left."), true);
                        } else if (capability.getRegenCount() >= 12) {
                            player.func_146105_b((ITextComponent)new TextComponentString("You're out of regenerations. You're dying this time."), true);
                        }
                    }
                    capability.syncToPlayer();
                }
            }
        }
    }

    public static class CapabilityTimelordProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private ITimelordCapability capability;

        public CapabilityTimelordProvider(ITimelordCapability capability) {
            this.capability = capability;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return TIMELORD_CAP != null && capability == TIMELORD_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == TIMELORD_CAP ? TIMELORD_CAP.cast((Object)this.capability) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)TIMELORD_CAP.getStorage().writeNBT(TIMELORD_CAP, (Object)this.capability, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            TIMELORD_CAP.getStorage().readNBT(TIMELORD_CAP, (Object)this.capability, null, (NBTBase)nbt);
        }
    }
}

