/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis.data;

import com.swdteam.common.data.PlayerData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class TardisData {
    private int exteriorID;
    private float travelRotation;
    private String previousLocationName = "MISSINGNO";
    private String currentLocationName = "MISSINGNO";
    private Vector3 travelToLocation;
    private UUID currentOwner;
    private float doorRotation = 0.0f;
    private float spawnFacing = 0.0f;
    private int tardisID = 0;
    private int[] tardisInteriorPosition = new int[]{0, 0};
    private String owner = "";
    private boolean isInFlight = false;
    @Deprecated
    private String exteriorType = "";
    private String interiorType = "";
    private List<PlayerData> companions = new ArrayList<PlayerData>();
    private List<Integer> unlocked_exteriors = new ArrayList<Integer>();
    private TardisPermission tardisPermissions = TardisPermission.NOBODY;
    private boolean forcefieldsEnabled = false;
    private boolean isLocked = false;
    private Vector3 tardisInteriorDoorLocation;
    private int tardisDimensionLocation = 0;
    private Vector3 currentTardisPosition;
    private Vector3 previousTardisPosition;
    private int tardisPreviousDimensionLocation = 0;
    private boolean doorOpen = false;
    private boolean inFlightMode = false;
    private transient ChameleonCircuitBase tardisSkin;
    private int orbitalEnergy = 100;

    public TardisData(int tardisID) {
        this.setTardisID(tardisID);
    }

    public int getOrbitalEnergy() {
        return this.orbitalEnergy;
    }

    public void setOrbitalEnergy(int orbitalEnergy) {
        this.orbitalEnergy = orbitalEnergy;
    }

    public boolean removeCompanion(String username) {
        if (this.companions == null) {
            this.companions = new ArrayList<PlayerData>();
        }
        for (PlayerData data : this.companions) {
            String tempUName = data.getUsername();
            if (!tempUName.toLowerCase().equals(username.toLowerCase())) continue;
            this.companions.remove(data);
            return true;
        }
        return false;
    }

    public void addCompanion(EntityPlayer p) {
        if (this.companions == null) {
            this.companions = new ArrayList<PlayerData>();
        }
        UUID uuid = p.func_110124_au();
        for (PlayerData data : this.companions) {
            UUID tempUUID = data.getPlayerUUID();
            if (!tempUUID.equals(uuid)) continue;
            return;
        }
        this.companions.add(new PlayerData(p.func_110124_au(), p.func_70005_c_()));
    }

    public void setCurrentTardisPosition(Vector3 currentTardisPosition) {
        this.currentTardisPosition = currentTardisPosition;
    }

    public void setDoorOpen(boolean doorOpen) {
        this.doorOpen = doorOpen;
    }

    public boolean isDoorOpen() {
        return this.doorOpen;
    }

    public void setForcefieldsEnabled(boolean forcefieldsEnabled) {
        this.forcefieldsEnabled = forcefieldsEnabled;
    }

    public void setInteriorType(String interiorType) {
        this.interiorType = interiorType;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int[] getTardisInteriorPosition() {
        return this.tardisInteriorPosition;
    }

    public int getInteriorX() {
        return this.tardisInteriorPosition[0];
    }

    public int getInteriorZ() {
        return this.tardisInteriorPosition[1];
    }

    public void setPreviousTardisPosition(Vector3 previousTardisPosition) {
        this.previousTardisPosition = previousTardisPosition;
    }

    public void setTardisDimensionLocation(int tardisDimensionLocation) {
        this.tardisDimensionLocation = tardisDimensionLocation;
    }

    public void setTardisInteriorDoorLocation(Vector3 tardisInteriorDoorLocation) {
        this.tardisInteriorDoorLocation = tardisInteriorDoorLocation;
    }

    public void setTardisPreviousDimensionLocation(int tardisPreviousDimensionLocation) {
        this.tardisPreviousDimensionLocation = tardisPreviousDimensionLocation;
    }

    public List<PlayerData> getCompanions() {
        return this.companions;
    }

    public boolean isCompanion(EntityPlayer p) {
        if (this.companions == null) {
            this.companions = new ArrayList<PlayerData>();
        }
        UUID uuid = p.func_110124_au();
        for (PlayerData data : this.companions) {
            UUID tempUUID = data.getPlayerUUID();
            if (!tempUUID.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public Vector3 getCurrentTardisPosition() {
        return this.currentTardisPosition;
    }

    public String getExteriorType() {
        return this.exteriorType;
    }

    public String getInteriorType() {
        return this.interiorType;
    }

    public String getOwner() {
        return this.owner;
    }

    public Vector3 getPreviousTardisPosition() {
        return this.previousTardisPosition;
    }

    public int getTardisDimensionLocation() {
        return this.tardisDimensionLocation;
    }

    public Vector3 getTardisInteriorDoorLocation() {
        return this.tardisInteriorDoorLocation;
    }

    public int getTardisPreviousDimensionLocation() {
        return this.tardisPreviousDimensionLocation;
    }

    private void setTardisID(int tardisID) {
        this.tardisID = tardisID;
    }

    public int getTardisID() {
        return this.tardisID;
    }

    public void setTardisInteriorPosition(int[] tardisInteriorPosition) {
        this.tardisInteriorPosition = tardisInteriorPosition;
    }

    public float getDoorRotation() {
        return this.doorRotation;
    }

    public void setDoorRotation(float doorRotation) {
        this.doorRotation = doorRotation;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setInFlight(boolean isInFlight) {
        this.isInFlight = isInFlight;
    }

    public boolean isInFlight() {
        return this.isInFlight;
    }

    public UUID getCurrentOwner() {
        return this.currentOwner;
    }

    public void setCurrentOwner(UUID currentOwner) {
        this.currentOwner = currentOwner;
    }

    public TardisPermission getTardisPermissions() {
        if (this.tardisPermissions == null) {
            this.tardisPermissions = TardisPermission.NOBODY;
        }
        return this.tardisPermissions;
    }

    public void setTardisPermissions(TardisPermission tardisPermissions) {
        this.tardisPermissions = tardisPermissions;
    }

    public String getCurrentLocationName() {
        return this.currentLocationName;
    }

    public String getPreviousLocationName() {
        return this.previousLocationName;
    }

    public void setCurrentLocationName(String currentLocationName) {
        this.currentLocationName = currentLocationName;
    }

    public void setPreviousLocationName(String previousLocationName) {
        this.previousLocationName = previousLocationName;
    }

    public float getSpawnFacing() {
        return this.spawnFacing;
    }

    public void setSpawnFacing(float spawnFacing) {
        this.spawnFacing = spawnFacing;
    }

    public Vector3 getTravelToLocation() {
        return this.travelToLocation;
    }

    public void setTravelToLocation(Vector3 travelToLocation) {
        this.travelToLocation = travelToLocation;
    }

    public int getExteriorID() {
        return this.exteriorID;
    }

    public void setExteriorID(int exteriorID) {
        this.exteriorID = exteriorID;
    }

    public void setInFlightMode(boolean inFlightMode) {
        this.inFlightMode = inFlightMode;
    }

    public boolean isInFlightMode() {
        return this.inFlightMode;
    }

    public String toString() {
        return TheDalekMod.GSON.toJson((Object)this);
    }

    public ChameleonCircuitBase getTardisSkin() {
        return this.tardisSkin;
    }

    public void setTardisSkin(ChameleonCircuitBase tardisSkin) {
        this.tardisSkin = tardisSkin;
    }

    public List<Integer> getUnlockedExteriors() {
        return this.unlocked_exteriors;
    }

    public void addExterior(int id) {
        this.unlocked_exteriors.add(id);
    }

    public void setTravelRotation(float travelRotation) {
        this.travelRotation = travelRotation;
    }

    public float getTravelRotation() {
        return this.travelRotation;
    }
}

