/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.swdteam.client.graphics.GraphicsManager;
import com.swdteam.client.gui.GuiTardisInterface;
import com.swdteam.client.model.tardis.ModelTardisBase;
import com.swdteam.client.render.gui.planets.IRenderPlanet;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.utils.DMUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Graphics {
    static int zLevel = 0;
    public static final float RENDER_NUM = 0.0625f;
    public static TextureManager render = Minecraft.func_71410_x().field_71446_o;
    public static HashMap<Chunk, Integer> chunks = new HashMap();

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    public static void draw(ResourceLocation r, float h, float y, float f, float g, int depth) {
        GL11.glPushMatrix();
        render.func_110577_a(r);
        Graphics.drawTexture(h, y, f, g, depth);
        GL11.glPopMatrix();
    }

    public static void drawNoBind(float x, float y, float width, float height, int depth) {
        GL11.glPushMatrix();
        Graphics.drawTexture(x, y, width, height, depth);
        GL11.glPopMatrix();
    }

    private static void drawTexture(float x, float y, float width, float height, double zLevel) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    private static void drawTextureOffset(float x, float y, float width, float height, double zLevel) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void FillRect(double x, double y, double width, double height, double zLevel, Color col) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)((float)col.getAlpha() / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void FillRect(double x, double y, double width, double height, double zLevel, int col) {
        float r = col >> 16 & 0xFF;
        float g = col >> 8 & 0xFF;
        float b = col & 0xFF;
        float a = col >> 24 & 0xFF;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(x, y + height, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x, y, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void bindTexture(int i) {
        GL11.glBindTexture((int)3553, (int)i);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(r);
    }

    public static void drawQuad(BufferBuilder buf, double x, double y, double width, double height) {
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buf.func_181662_b(x, y + height, 0.0).func_181675_d();
        buf.func_181662_b(x + width, y + height, 0.0).func_181675_d();
        buf.func_181662_b(x + width, y, 0.0).func_181675_d();
        buf.func_181662_b(x, y, 0.0).func_181675_d();
        buf.func_178977_d();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        float f2 = 0.00390625f;
        float f3 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + (float)maxV), (double)zLevel).func_187315_a((double)((float)(minU + 0) * f2), (double)((float)(minV + maxV) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + (float)maxV), (double)zLevel).func_187315_a((double)((float)(minU + maxU) * f2), (double)((float)(minV + maxV) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + 0.0f), (double)zLevel).func_187315_a((double)((float)(minU + maxU) * f2), (double)((float)(minV + 0) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)zLevel).func_187315_a((double)((float)(minU + 0) * f2), (double)((float)(minV + 0) * f3)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawWithBlendingMode(ResourceLocation r, float x, float y, float width, float height, int depth, int BLEND_1, int BLEND_2) {
        GL11.glPushMatrix();
        render.func_110577_a(r);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)BLEND_1, (int)BLEND_2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderBlock(World world, BlockPos pos, IBlockState blockState) {
        Graphics.bindTexture(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        if (blockState.func_185901_i() == EnumBlockRenderType.MODEL && !blockState.func_177230_c().hasTileEntity(blockState)) {
            GlStateManager.func_179094_E();
            IBakedModel ibakedmodel = blockrendererdispatcher.func_175023_a().func_178125_b(blockState);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)world, ibakedmodel, blockState, pos, vertexBuffer, true);
            GlStateManager.func_179121_F();
        }
        tessellator.func_78381_a();
    }

    public static void renderBlocks(World world, BlockPos[] pos, IBlockState[] blockStates) {
        if (pos.length != blockStates.length) {
            throw new IllegalArgumentException("pos and blockstates must match up");
        }
        Graphics.bindTexture(TextureMap.field_110575_b);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        for (int i = 0; i < blockStates.length; ++i) {
            if (blockStates[i] == null || pos[i] == null || blockStates[i].func_177230_c() == Blocks.field_150350_a || blockStates[i].func_185901_i() != EnumBlockRenderType.MODEL || blockStates[i].func_177230_c().hasTileEntity(blockStates[i])) continue;
            Graphics.bindTexture(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            IBakedModel ibakedmodel = blockrendererdispatcher.func_175023_a().func_178125_b(blockStates[i]);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)world, ibakedmodel, blockStates[i], pos[i], vertexBuffer, true);
            GlStateManager.func_179121_F();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void renderChunk(Chunk c, int yOffset, int height) {
        if (!chunks.containsKey(c)) {
            World world = c.func_177412_p();
            if (!c.func_177410_o()) {
                world.func_72863_F().func_186025_d(c.field_76635_g, c.field_76647_h);
                return;
            }
            int i = GL11.glGenLists((int)1);
            chunks.put(c, i);
            GL11.glNewList((int)i, (int)4864);
            Graphics.bindTexture(TextureMap.field_110575_b);
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            for (int x = 0; x < 16; ++x) {
                for (int y = yOffset; y < height; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        boolean flag;
                        Block block = c.func_186032_a(x, y, z).func_177230_c();
                        BlockPos blockpos = new BlockPos(x, y, z);
                        if (block == null || block == Blocks.field_150350_a) continue;
                        boolean bl = flag = x == 0 || x == 15 || y == 0 || y == 15;
                        if (!flag && c.func_177435_g(blockpos.func_177982_a(-1, 0, 0)) != Blocks.field_150350_a && c.func_177435_g(blockpos.func_177982_a(1, 0, 0)) != Blocks.field_150350_a && c.func_177435_g(blockpos.func_177982_a(0, 1, 0)) != Blocks.field_150350_a && c.func_177435_g(blockpos.func_177982_a(0, -1, 0)) != Blocks.field_150350_a && c.func_177435_g(blockpos.func_177982_a(0, 0, 1)) != Blocks.field_150350_a && c.func_177435_g(blockpos.func_177982_a(0, 0, -1)) != Blocks.field_150350_a) continue;
                        IBlockState iblockstate = block.func_176203_a(c.func_177435_g(blockpos).func_177230_c().func_176201_c(c.func_177435_g(blockpos)));
                        if (block.func_149645_b(iblockstate) == EnumBlockRenderType.MODEL && !block.func_149716_u()) {
                            Graphics.bindTexture(TextureMap.field_110575_b);
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
                            IBakedModel ibakedmodel = blockrendererdispatcher.func_175023_a().func_178125_b(iblockstate);
                            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)world, ibakedmodel, iblockstate, blockpos, vertexBuffer, true);
                            GlStateManager.func_179121_F();
                        }
                        if (!block.func_149716_u() || block == DMBlocks.bTEChunkHologram) continue;
                        TileEntity t = world.func_175625_s(new BlockPos(c.field_76635_g * 16 + x, y, c.field_76647_h * 16 + z));
                        GL11.glPushMatrix();
                        t.func_145839_a(new NBTTagCompound());
                        if (t != null) {
                            // empty if block
                        }
                        GL11.glPopMatrix();
                    }
                }
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GL11.glEndList();
        } else {
            GL11.glCallList((int)chunks.get(c));
            Graphics.bindTexture(TextureMap.field_110575_b);
        }
    }

    public static void reloadChunk(Chunk c) {
        chunks.remove(c);
    }

    public static float renderNum() {
        return 0.0625f;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTileEntityBounds(TileEntity tileentity1) {
        GlStateManager.func_179094_E();
        GlStateManager.func_187409_d((int)1032, (int)6913);
        GlStateManager.func_179109_b((float)(-tileentity1.func_174877_v().func_177958_n()), (float)(-tileentity1.func_174877_v().func_177956_o()), (float)(-tileentity1.func_174877_v().func_177952_p()));
        GlStateManager.func_179109_b((float)-0.5f, (float)-1.5f, (float)-0.5f);
        Render.func_76978_a((AxisAlignedBB)tileentity1.getRenderBoundingBox(), (double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_187409_d((int)1032, (int)6914);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlockBoundsWithinAABB(AxisAlignedBB b) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.75f, (float)0.4f);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GL11.glScalef((float)1.01f, (float)1.01f, (float)1.01f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        vertexBuffer.func_181663_c(0.0f, 0.0f, -1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 0.0f, 1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, -1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(-1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.2f, (float)0.2f, (float)1.0f, (float)0.5f);
        GL11.glPolygonMode((int)1032, (int)6913);
        GlStateManager.func_179090_x();
        GL11.glScalef((float)1.01f, (float)1.01f, (float)1.01f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        vertexBuffer.func_181663_c(0.0f, 0.0f, -1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 0.0f, 1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, -1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(-1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGUIBack(int x, int y, int width, int height) {
        Graphics.FillRect((double)x, (double)y, (double)width, (double)height, 0.0, GraphicsManager.GUI_BACK);
        Graphics.FillRect((double)x, (double)(y - 3), (double)width, 1.0, 0.0, Color.black);
        Graphics.FillRect((double)x, (double)(y - 2), (double)width, 2.0, 0.0, Color.white);
        Graphics.FillRect((double)(x - 3), (double)y, 1.0, (double)height, 0.0, Color.black);
        Graphics.FillRect((double)(x - 2), (double)y, 2.0, (double)height, 0.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)y, 2.0, (double)height, 0.0, Color.darkGray);
        Graphics.FillRect((double)(x + width + 2), (double)y, 1.0, (double)height, 0.0, Color.black);
        Graphics.FillRect((double)x, (double)(y + height), (double)width, 2.0, 0.0, Color.darkGray);
        Graphics.FillRect((double)x, (double)(y + height + 2), (double)width, 1.0, 0.0, Color.black);
        Graphics.bindTexture(DMUtils.GUI_BACK_PARTS);
        Gui.func_146110_a((int)(x - 3), (int)(y - 3), (float)0.0f, (float)0.0f, (int)4, (int)4, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x + width), (int)(y - 2), (float)4.0f, (float)2.0f, (int)4, (int)2, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x + width - 1), (int)(y + height - 1), (float)0.0f, (float)4.0f, (int)4, (int)4, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x - 2), (int)(y + height), (float)4.0f, (float)0.0f, (int)4, (int)2, (float)16.0f, (float)16.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGUIEdges(int x, int y, int width, int height) {
        ScaledResolution s = new ScaledResolution(Minecraft.func_71410_x());
        Graphics.FillRect(0.0, 0.0, (double)s.func_78326_a(), (double)y, 1.0, Color.gray);
        Graphics.FillRect(0.0, (double)(y + height), (double)s.func_78326_a(), (double)(s.func_78328_b() - height - y), 1.0, Color.gray);
        Graphics.FillRect(0.0, 0.0, (double)x, (double)s.func_78328_b(), 1.0, Color.gray);
        Graphics.FillRect((double)(width + x), 1.0, (double)(s.func_78326_a() - width - x), (double)s.func_78328_b(), 1.0, Color.gray);
        Graphics.FillRect((double)(x + 1), (double)y, (double)(width - 1), 1.0, 1.0, Color.black);
        Graphics.FillRect((double)(x + 1), (double)(y - 2), (double)(width - 1), 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)x, (double)(y + 1), 1.0, (double)(height - 1), 1.0, Color.black);
        Graphics.FillRect((double)(x - 2), (double)(y + 1), 2.0, (double)(height - 1), 1.0, Color.darkGray);
        Graphics.FillRect((double)(x + width + 1), (double)(y + 1), 2.0, (double)(height - 1), 1.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)(y + 1), 1.0, (double)(height - 1), 1.0, Color.black);
        Graphics.FillRect((double)(x + 1), (double)(y + height + 1), (double)(width - 1), 2.0, 1.0, Color.white);
        Graphics.FillRect((double)(x + 1), (double)(y + height), (double)(width - 1), 1.0, 1.0, Color.black);
        Graphics.FillRect((double)(x - 1), (double)(y - 1), 2.0, 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)(x - 1), (double)(y + height), 2.0, 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)(x + width), (double)(y + height), 2.0, 2.0, 1.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)(y - 1), 2.0, 2.0, 1.0, Color.white);
    }

    @SideOnly(value=Side.CLIENT)
    public static void brightRender() {
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawModelToGui(ModelBase model, int xPos, int yPos, float par2, float rotation) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)xPos, (float)yPos, (float)100.0f);
        GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f));
        if (model instanceof ModelTardisBase) {
            GL11.glScalef((float)(38.0f * par2), (float)(34.0f * par2), (float)(38.0f * par2));
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            ((ModelTardisBase)model).renderAll(Graphics.renderNum());
        } else {
            GL11.glScalef((float)(38.0f * par2), (float)(34.0f * par2), (float)(38.0f * par2));
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            model.func_78088_a((Entity)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, DMUtils.handleRotationFloat((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, 0.0f), 0.0f, 0.0f, Graphics.renderNum());
        }
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderPlanetRenderer(GuiTardisInterface gui, IRenderPlanet planet, int xPos, int yPos, float par2, float rotation) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)xPos, (float)yPos, (float)100.0f);
        GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f));
        GL11.glScalef((float)(38.0f * par2), (float)(34.0f * par2), (float)(38.0f * par2));
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        planet.render(gui, xPos, yPos);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSymbol(ResourceLocation r, float x, float y, float width, float height, float speed, float rotation) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.4f * ((speed <= 0.0f ? speed * -1.0f : speed) / 2.0f)));
        GL11.glTranslatef((float)(-width / 2.0f), (float)(-height / 2.0f), (float)0.0f);
        GL11.glTranslatef((float)(x + width / 2.0f), (float)(y + height / 2.0f), (float)0.0f);
        GL11.glRotatef((float)(rotation * speed), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-width / 2.0f), (float)(-height / 2.0f), (float)0.0f);
        Graphics.draw(r, 0.0f, 0.0f, (int)width, (int)height, 0);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getTextureForPlayer(String username) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        resourcelocation = AbstractClientPlayer.func_110311_f((String)username);
        AbstractClientPlayer.func_110304_a((ResourceLocation)resourcelocation, (String)username);
        return resourcelocation;
    }
}

