/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.google.gson.reflect.TypeToken;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class SchemUtils {
    public static String modid = "thedalekmod";

    public static void init() {
        Schematic s = SchemUtils.getSchematic("fourthSec");
        SchemUtils.copySchematicToJson("fourth_secondary", s);
    }

    public static SWDSchematic loadSchematic(String s) throws Exception {
        InputStream is = SchemUtils.class.getClassLoader().getResourceAsStream("assets/" + modid + "/schematics/" + s + ".dat");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = "";
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        reader.close();
        Type typeList = new TypeToken<List<BlockData>>(){}.getType();
        SWDSchematic schem = new SWDSchematic(TheDalekMod.GSON.fromJson(DMUtils.decrypt(sb.toString()), typeList));
        return schem;
    }

    public static Schematic getSchematic(String schemname) {
        try {
            InputStream is = SchemUtils.class.getClassLoader().getResourceAsStream("assets/" + modid + "/schematics/" + schemname + ".schematic");
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            byte[] addId = new byte[]{};
            short[] blocksNew = new short[blocks.length];
            if (nbtdata.func_74764_b("AddBlocks")) {
                addId = nbtdata.func_74770_j("AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocksNew[index] = index >> 1 >= addId.length ? (short)(blocks[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blocks[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blocks[index] & 0xFF)));
            }
            NBTTagList tileentities = nbtdata.func_150295_c("TileEntities", 10);
            is.close();
            Schematic s = new Schematic(tileentities, width, height, length, blocksNew, data);
            SchemUtils.copySchematicToJson(schemname, s);
            return s;
        }
        catch (Exception e) {
            System.out.println("I can't load schematic, because " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public static void generateSchematic(SWDSchematic schematic, World world, int x, int y, int z) {
        BlockPos p1 = new BlockPos(x, y, z);
        world.func_175656_a(p1, Blocks.field_150335_W.func_176223_P());
        try {
            if (schematic != null && schematic.data != null) {
                for (BlockData data : schematic.data) {
                    NBTTagCompound nbttagcompound4;
                    TileEntity tileentity;
                    Block block = null;
                    block = data.iDM ? DMBlocks.DM_BLOCKS.get(data.i) : Block.func_149729_e((int)data.i);
                    IBlockState state = block.func_176203_a(data.md);
                    BlockPos p = new BlockPos(x + data.p.getX(), y + data.p.getY(), z + data.p.getZ());
                    world.func_180501_a(p, state, 2);
                    WorldUtils.markBlockForUpdate(world, p);
                    if (data.nbt == null || data.nbt.length() <= 0 || (tileentity = TileEntity.func_190200_a((World)world, (NBTTagCompound)(nbttagcompound4 = JsonToNBT.func_180713_a((String)data.nbt)))) == null) continue;
                    world.func_175690_a(tileentity.func_174877_v().func_177982_a(x, y, z), tileentity);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateSchematic(Schematic schematic, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            if (schematic == null) {
                System.out.println("Schematic does not exist!");
                return;
            }
            int i = 0;
            for (int sy = 0; sy < schematic.height; ++sy) {
                for (int sz = 0; sz < schematic.length; ++sz) {
                    for (int sx = 0; sx < schematic.width; ++sx) {
                        Block block = Block.func_149729_e((int)schematic.blocks[i]);
                        int meta = Integer.parseInt(String.valueOf(schematic.getData()[i]));
                        if (block != Blocks.field_150350_a && block != DMBlocks.bTEtcnloader) {
                            BlockPos p = new BlockPos(x + sx, y + sy, z + sz);
                            world.func_175698_g(p);
                            world.func_180501_a(p, block.func_176203_a(meta), 0);
                            WorldUtils.markBlockForUpdate(world, p);
                        }
                        ++i;
                    }
                }
            }
            if (schematic.tileentities != null) {
                for (int i1 = 0; i1 < schematic.tileentities.func_74745_c(); ++i1) {
                    NBTTagCompound nbttagcompound4 = schematic.tileentities.func_150305_b(i1);
                    TileEntity tileentity = TileEntity.func_190200_a((World)world, (NBTTagCompound)nbttagcompound4);
                    if (tileentity == null) continue;
                    world.func_175690_a(tileentity.func_174877_v().func_177982_a(x, y, z), tileentity);
                }
            }
        }
    }

    public static void copySchematicToJson(String schemName, Schematic schematic) {
        String fileDir;
        File f;
        int i = 0;
        ArrayList<BlockData> data = new ArrayList<BlockData>();
        for (int sy = 0; sy < schematic.height; ++sy) {
            for (int sz = 0; sz < schematic.length; ++sz) {
                for (int sx = 0; sx < schematic.width; ++sx) {
                    Block block = Block.func_149729_e((int)schematic.blocks[i]);
                    if (block != Blocks.field_150350_a) {
                        int meta = Integer.parseInt(String.valueOf(schematic.getData()[i]));
                        BlockData d = new BlockData();
                        if (DMBlocks.DM_BLOCKS.contains(block)) {
                            d.iDM = true;
                            d.i = DMBlocks.DM_BLOCKS.indexOf(block);
                        } else {
                            d.iDM = false;
                            d.i = schematic.blocks[i];
                        }
                        d.p = new Vector3(sx, sy, sz);
                        d.md = meta;
                        data.add(d);
                    }
                    ++i;
                }
            }
        }
        if (schematic.tileentities != null) {
            for (int i1 = 0; i1 < schematic.tileentities.func_74745_c(); ++i1) {
                NBTTagCompound nbttagcompound4 = schematic.tileentities.func_150305_b(i1);
                TileEntity tileentity = TileEntity.func_190200_a(null, (NBTTagCompound)nbttagcompound4);
                for (BlockData da : data) {
                    if (da.p.getX() != tileentity.func_174877_v().func_177958_n() || da.p.getY() != tileentity.func_174877_v().func_177956_o() || da.p.getZ() != tileentity.func_174877_v().func_177952_p()) continue;
                    da.nbt = nbttagcompound4.toString();
                }
            }
        }
        if (!(f = new File((fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath()) + "/mods/Dalek Mod/schem/")).exists()) {
            f.mkdirs();
            System.out.println("Creating Dalek Mod Schem Directory");
        }
        try {
            Type typeList = new TypeToken<List<BlockData>>(){}.getType();
            FileWriter writer = new FileWriter(new File(f.getAbsolutePath() + "/" + schemName + ".dat"));
            writer.write(DMUtils.encrypt(TheDalekMod.GSON.toJson(data, typeList)));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SWDSchematic {
        public List<BlockData> data = new ArrayList<BlockData>();

        public SWDSchematic(Object object) {
            if (object instanceof List) {
                this.data = (List)object;
            }
        }
    }

    public static class Schematic {
        public NBTTagList tileentities;
        public short width;
        public short height;
        public short length;
        public short[] blocks;
        public byte[] data;

        public Schematic(NBTTagList tileentities, short width, short height, short length, short[] blocks, byte[] data) {
            this.tileentities = tileentities;
            this.width = width;
            this.height = height;
            this.length = length;
            this.blocks = blocks;
            this.data = data;
        }

        public NBTTagList getTileEntities() {
            return this.tileentities;
        }

        public short getWidth() {
            return this.width;
        }

        public short getHeight() {
            return this.height;
        }

        public short getLength() {
            return this.length;
        }

        public short[] getBlocks() {
            return this.blocks;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static class BlockData {
        public boolean iDM;
        public int i;
        public int md;
        public Vector3 p;
        public String nbt;
    }
}

