/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.data.ServerDataHub;
import com.swdteam.client.gui.title.backgrounds.GuiPanoramaDMUHub;
import com.swdteam.client.init.DMTextures;
import com.swdteam.client.overlay.OverlaySonicShades;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiDMUHubWorld
extends GuiScreen {
    private boolean isLoading = true;
    private boolean serverOffline = false;
    private ServerDataHub serverData;
    private static final GuiPanoramaDMUHub BG = new GuiPanoramaDMUHub();
    private ScheduledExecutorService exec;
    private GuiScreen previousScreen;
    List<String> l = new ArrayList<String>();
    private static final String HOST = "dmu.swdteam.co.uk";
    private static final int PORT = 25576;

    public GuiDMUHubWorld(GuiScreen previousScreen) {
        this.previousScreen = previousScreen;
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "http://dmu.swdteam.co.uk/api/scripts/getAllPlayers.php";
                    String response = IOUtils.getJsonFromURL(url);
                    GuiDMUHubWorld.this.serverData = (ServerDataHub)TheDalekMod.GSON.fromJson(response, ServerDataHub.class);
                    GuiDMUHubWorld.this.isLoading = false;
                    if (GuiDMUHubWorld.this.serverData == null) {
                        GuiDMUHubWorld.this.serverOffline = true;
                    }
                }
                catch (Exception e) {
                    GuiDMUHubWorld.this.serverOffline = true;
                    GuiDMUHubWorld.this.isLoading = false;
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 145, this.field_146295_m / 2 + 62, 71, 20, "Cancel"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 73, this.field_146295_m / 2 + 62, 72, 20, "DMU Public"));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2, this.field_146295_m / 2 + 62, 72, 20, "DMU Private"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 + 73, this.field_146295_m / 2 + 62, 72, 20, "DMU Creative"));
        GuiButton joinServerBtn = new GuiButton(1, this.field_146294_l / 2 - 145, this.field_146295_m / 2 + 40, 290, 20, "Select a server from below");
        this.field_146292_n.add(joinServerBtn);
        joinServerBtn.field_146124_l = false;
    }

    public void func_146281_b() {
        this.exec.shutdownNow();
        super.func_146281_b();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.l.clear();
        BG.render(this.field_146294_l, this.field_146295_m, mouseX, mouseY, partialTicks);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        Graphics.draw(OverlaySonicShades.OVERLAY, 0.0f, 0.0f, this.field_146294_l, this.field_146295_m, 0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 - 100), 320.0, 200.0, 0.0, -872415232);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 - 101), 322.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 - 100), 1.0, 200.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 + 160), (double)(this.field_146295_m / 2 - 100), 1.0, 200.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 + 100), 322.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 80), (double)(this.field_146295_m / 2 - 78), 160.0, 1.0, 0.0, -1);
        this.func_73732_a(this.field_146289_q, "Dalek Mod Universe", this.field_146294_l / 2, this.field_146295_m / 2 - 90, 0xFFFFFF);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 - 52), 320.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 + 34), 320.0, 1.0, 0.0, -1);
        this.func_73732_a(this.field_146289_q, "(Any issues please visit SWDTeam.com/forums)", this.field_146294_l / 2, this.field_146295_m / 2 + 87, 0x555555);
        if (this.isLoading) {
            this.func_73732_a(this.field_146289_q, "Loading...", this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFFFF00);
        } else if (this.serverOffline || this.serverData == null || this.serverData != null && this.serverData.getPlayers() == null) {
            this.func_73732_a(this.field_146289_q, "Server Offline", this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFF0000);
        } else {
            this.field_146289_q.func_175065_a("Players Online: (" + this.serverData.getPlayers().length + "/" + this.serverData.getMaximumPlayers() + ")", (float)(this.field_146294_l / 2 - 142), (float)(this.field_146295_m / 2 - 64), 0xFFFFFF, true);
            for (int i = 0; i < 64; ++i) {
                float rowMax = 16.0f;
                int xPos = this.field_146294_l / 2 - 142 + 18 * (i % (int)rowMax);
                float in = (float)i / rowMax;
                int yPos = this.field_146295_m / 2 - 44 + 18 * MathHelper.func_76141_d((float)in);
                if (i < this.serverData.getPlayers().length) {
                    ServerDataHub.Player player = this.serverData.getPlayers()[i];
                    Graphics.bindTexture(Graphics.getTextureForPlayer(player.getUsername()));
                    GuiDMUHubWorld.func_146110_a((int)xPos, (int)yPos, (float)16.0f, (float)16.0f, (int)16, (int)16, (float)128.0f, (float)128.0f);
                    GuiDMUHubWorld.func_146110_a((int)xPos, (int)yPos, (float)80.0f, (float)16.0f, (int)16, (int)16, (float)128.0f, (float)128.0f);
                    if (mouseX <= xPos || mouseX >= xPos + 16 || mouseY <= yPos || mouseY >= yPos + 16) continue;
                    this.l.add(TextFormatting.YELLOW + "" + TextFormatting.BOLD + player.getUsername());
                    this.l.add("Server: " + player.getServerName());
                    continue;
                }
                Graphics.draw(DMTextures.grey_head.getResourceLocation(), xPos, yPos, 16.0f, 16.0f, 0);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.serverData != null && this.serverData.getMessage() != null && this.serverData.getMessage().length() > 0) {
            Graphics.FillRect((double)(this.field_146294_l / 2 - 144), (double)(this.field_146295_m / 2 + 41), 288.0, 18.0, 0.0, -13434880);
            this.func_73732_a(this.field_146289_q, this.serverData.getMessage(), this.field_146294_l / 2, this.field_146295_m / 2 + 46, -1);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146283_a(this.l, mouseX, mouseY);
    }

    public void func_73876_c() {
        BG.update(this.field_146294_l, this.field_146295_m, 0, 0);
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            Minecraft.func_71410_x().func_147108_a(this.previousScreen);
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25576));
        }
        if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25564));
        }
        if (button.field_146127_k == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25565));
        }
        if (button.field_146127_k == 4) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25569));
        }
        super.func_146284_a(button);
    }
}

