/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.data;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ShopData {
    public static ItemStack stack = new ItemStack(Blocks.field_150350_a);
    private String shopName;
    private String shopIdentifier;
    private ShopItem[] items;

    public ShopData(String name) {
        this.shopName = name;
    }

    public ShopItem[] getItems() {
        return this.items;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setItems(ShopItem[] items) {
        this.items = items;
    }

    public String getShopIdentifier() {
        return this.shopIdentifier;
    }

    public void setShopIdentifier(String shopIdentifier) {
        this.shopIdentifier = shopIdentifier;
    }

    public static class ShopItem {
        private ItemStack item;
        private int itemPrice;
        private int itemAmount;
        private int itemMetadata;
        private String itemIdentifier = "";
        private NBTTagCompound itemNBT;

        public ShopItem(String itemIdentifier, int metadata, int amount, int price, NBTTagCompound tag) {
            this.itemPrice = price;
            this.itemIdentifier = itemIdentifier;
            this.itemMetadata = metadata;
            this.itemNBT = tag;
            this.itemAmount = amount;
        }

        public ShopItem(String itemIdentifier, int metadata, int amount, int price) {
            this(itemIdentifier, metadata, amount, price, new NBTTagCompound());
        }

        public ShopItem(String itemIdentifier, int metadata, int price) {
            this(itemIdentifier, metadata, 1, price, new NBTTagCompound());
        }

        public ShopItem(String itemIdentifier, int price) {
            this(itemIdentifier, 0, 1, price, new NBTTagCompound());
        }

        public ShopItem(int amount, String itemIdentifier, int price) {
            this(itemIdentifier, 0, amount, price, new NBTTagCompound());
        }

        public ItemStack getItem() {
            if (this.item == null) {
                try {
                    this.item = new ItemStack(ShopItem.getItemFromString(this.itemIdentifier), this.itemAmount, this.itemMetadata);
                    this.item.func_77982_d(this.itemNBT);
                }
                catch (Exception e) {
                    this.item = stack;
                    return this.item;
                }
            }
            return this.item;
        }

        public static Item getItemFromString(String s) {
            ResourceLocation resourcelocation = new ResourceLocation(s);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourcelocation);
            return item;
        }

        public int getItemPrice() {
            return this.itemPrice;
        }
    }
}

