/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.dimensions;

import com.swdteam.client.init.DMTextures;
import com.swdteam.common.dimensions.world.WorldProviderMoon;
import com.swdteam.common.dimensions.world.WorldProviderSkaro;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.dimensions.world.WorldProviderTrenzalore;
import com.swdteam.common.dimensions.world.WorldProviderVaros;
import com.swdteam.common.planets.IPlanet;
import com.swdteam.main.config.DMConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DMDimensions {
    private static List<Integer> planet_ordered_list = new ArrayList<Integer>();
    private static HashMap<Integer, IPlanet> planets = new HashMap();
    public static DimensionType DIM_TARDIS;
    public static final int DIM_TARDIS_ID;
    public static DimensionType DIM_SKARO;
    public static final int DIM_SKARO_ID;
    public static DimensionType DIM_TRENZALORE;
    public static final int DIM_TRENZALORE_ID;
    public static DimensionType DIM_MOON;
    public static final int DIM_MOON_ID;
    public static DimensionType DIM_VAROS;
    public static final int DIM_VAROS_ID;

    public static void init() {
        DIM_TARDIS = DimensionType.register((String)"TARDIS", (String)"_tardis", (int)DIM_TARDIS_ID, WorldProviderTardis.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_TARDIS_ID, (DimensionType)DIM_TARDIS);
        DIM_SKARO = DimensionType.register((String)"SKARO", (String)"_skaro", (int)DIM_SKARO_ID, WorldProviderSkaro.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_SKARO_ID, (DimensionType)DIM_SKARO);
        DIM_TRENZALORE = DimensionType.register((String)"TRENZALORE", (String)"_trenzalore", (int)DIM_TRENZALORE_ID, WorldProviderTrenzalore.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_TRENZALORE_ID, (DimensionType)DIM_TRENZALORE);
        DIM_MOON = DimensionType.register((String)"MOON", (String)"_moon", (int)DIM_MOON_ID, WorldProviderMoon.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_MOON_ID, (DimensionType)DIM_MOON);
        DIM_VAROS = DimensionType.register((String)"VAROS", (String)"_varos", (int)DIM_VAROS_ID, WorldProviderVaros.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_VAROS_ID, (DimensionType)DIM_VAROS);
        DMDimensions.addPlanet(0, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_EARTH.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Overworld";
            }
        });
        DMDimensions.addPlanet(DIM_VAROS_ID, new IPlanet(){

            @Override
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_VAROS.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Varos";
            }
        });
        DMDimensions.addPlanet(DIM_MOON_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_MOON.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Moon";
            }
        });
        DMDimensions.addPlanet(DIM_SKARO_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_SKARO.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Skaro";
            }
        });
        DMDimensions.addPlanet(DIM_TRENZALORE_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_TRENZALORE.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Trenzalore";
            }
        });
        DMDimensions.addPlanet(-1, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_NETHER.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "Nether";
            }
        });
        DMDimensions.addPlanet(1, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetTexture() {
                return DMTextures.PLANET_END.getResourceLocation();
            }

            @Override
            public String getPlanetName() {
                return "End";
            }
        });
    }

    public static void addPlanet(int dimID, IPlanet planet) {
        planets.put(dimID, planet);
        planet_ordered_list.add(dimID);
    }

    public static IPlanet getPlanetForDimension(int id) {
        if (planets.containsKey(id)) {
            return planets.get(id);
        }
        return planets.get(0);
    }

    public static int getIndexOfDimension(int id) {
        if (planet_ordered_list.contains(id)) {
            return planet_ordered_list.indexOf(id);
        }
        return 0;
    }

    public static int getIDOfDimensionAtIndex(int id) {
        if (planet_ordered_list.size() > id) {
            return planet_ordered_list.get(id);
        }
        return 0;
    }

    public static HashMap<Integer, IPlanet> getPlanets() {
        return planets;
    }

    public static List<Integer> getPlanetOrderedList() {
        return planet_ordered_list;
    }

    static {
        DIM_TARDIS_ID = DMConfig.DimensionIDs.Tardis_Dimension_ID;
        DIM_SKARO_ID = DMConfig.DimensionIDs.Skaro_Dimension_ID;
        DIM_TRENZALORE_ID = DMConfig.DimensionIDs.Trenzalore_Dimension_ID;
        DIM_MOON_ID = DMConfig.DimensionIDs.Moon_Dimension_ID;
        DIM_VAROS_ID = DMConfig.DimensionIDs.Varos_Dimension_ID;
    }
}

