/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main.config;

import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.ReflectionUtil;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="thedalekmod")
public class DMConfig {
    @Config.Name(value="Client Side")
    @Config.LangKey(value="config.side.client")
    public static final Client ClientSide = new Client();
    @Config.Name(value="Server Side")
    @Config.LangKey(value="config.side.server")
    public static final Server ServerSide = new Server();
    @Config.Name(value="Mobs")
    @Config.LangKey(value="config.mobs")
    public static final Mobs Mobs = new Mobs();
    @Config.Name(value="Debug")
    @Config.LangKey(value="config.debug")
    public static final Debug Debug = new Debug();
    @Config.Name(value="Dimension IDs")
    @Config.LangKey(value="config.dims")
    @Config.RequiresMcRestart
    public static final DimensionIDs DimensionIDs = new DimensionIDs();

    @Mod.EventBusSubscriber
    static class ConfigurationHolder {
        private static final MethodHandle CONFIGS_GETTER = ReflectionUtil.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        ConfigurationHolder() {
        }

        static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "thedalekmod.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "thedalekmod.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    if (entryOptional.isPresent()) {
                        configuration = (Configuration)entryOptional.get().getValue();
                    }
                }
                catch (Throwable throwable) {
                    TheDalekMod.LOG.error("Failed to get Configuration instance");
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("thedalekmod")) {
                ConfigManager.load((String)"thedalekmod", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Debug {
        @Config.Name(value="Extended mod log output")
        public boolean debug_game_output = false;
    }

    public static class Server {
        @Config.Name(value="Nitro-9")
        @Config.LangKey(value="Disables Nitro-9 usage.")
        public boolean NITRO_9 = true;
        @Config.Name(value="Dalek Spawn Rate")
        public int DalekSpawnRate = 10;
        @Config.Name(value="Sonic Blaster")
        @Config.LangKey(value="config.sonic_blaster")
        public boolean SONIC_BLASTER = true;
        @Config.Name(value="Drop Tardis Item")
        public boolean DROP_TARDIS_ITEM = true;
        @Config.Name(value="Acid Rain")
        @Config.LangKey(value="config.acid_rain")
        public boolean ACID_RAIN = true;
        @Config.Name(value="Spawn Daleks")
        public boolean SPAWN_DALEKS = true;
        @Config.Name(value="Air loss")
        @Config.LangKey(value="config.air")
        public boolean Air_Suits = true;
    }

    public static class Client {
        @Config.Name(value="Sky box levels")
        @Config.RangeInt
        public int SKY_BOX_LEVELS = 32;
        @Config.Name(value="Show sky boxes")
        @Config.LangKey(value="Toggle Dalek Mod Skyboxes")
        public boolean SHOW_SKY_BOX = true;
        @Config.Name(value="Panel names")
        public boolean PANEL_HIGHLIGHTS = true;
        @Config.Name(value="Custom Title Screen")
        @Config.LangKey(value="config.title")
        public boolean CUSTOM_TITLE_SCREEN = true;
        @Config.Name(value="Sonic Shade commands")
        @Config.LangKey(value="config.sonic_shades")
        public boolean SONIC_SHADE_VOICE_COMMANDS = true;
    }

    public static class Mobs {
        @Config.Name(value="Suicide Dalek Exploding")
        @Config.LangKey(value="config.ExplodingDaleks")
        public boolean Dalek_Suicide = true;
        @Config.Name(value="SWD Daleks grief")
        @Config.LangKey(value="Toggle the explosiveness of SWD Daleks")
        public boolean Dalek_SWD = true;
        @Config.Name(value="Weeping Angels grief")
        @Config.LangKey(value="config.angel_light_break")
        public boolean Angel_Light = true;
        @Config.Name(value="Weeping Angels teleporting player")
        @Config.LangKey(value="config.angel_teleport")
        public boolean Angel_Teleport = true;
        @Config.Name(value="Cybermat griefing")
        public boolean Matt_Griefing = true;
        @Config.Name(value="Classic Player Griefing")
        public boolean Classic_Grief = true;
    }

    public static class DimensionIDs {
        @Config.Name(value="TARDIS Dimension ID")
        public int Tardis_Dimension_ID = 2;
        @Config.Name(value="Skaro ID")
        public int Skaro_Dimension_ID = 3;
        @Config.Name(value="Moon ID")
        public int Moon_Dimension_ID = 4;
        @Config.Name(value="Classic Dimension ID")
        public int Minecraft_Classic_Dimension_ID = 5;
        @Config.Name(value="Cave Game ID")
        public int Minecraft_Cave_Game_Dimension_ID = 6;
        @Config.Name(value="Trenzalore ID")
        public int Trenzalore_Dimension_ID = 7;
        @Config.Name(value="Varos ID")
        public int Varos_Dimension_ID = 8;
    }
}

