/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.item;

import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemStatRemote
extends Item {
    public ItemStatRemote() {
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            TardisData data;
            ItemStack stack = player.func_184586_b(hand);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityTardis) {
                TileEntityTardis tet = (TileEntityTardis)te;
                data = tet.tempTardisData;
                if (data != null) {
                    if (data.getCurrentOwner() == null && data.getOwner().equals(player.func_70005_c_())) {
                        data.setCurrentOwner(player.func_110124_au());
                        TardisSaveHandler.saveTardis(data);
                    }
                    if (DMTardis.hasPermission(data, player)) {
                        if (!player.func_70093_af()) {
                            boolean b = data.isLocked();
                            data.setLocked(!b);
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have " + (b ? "unlocked" : "locked") + " your Tardis"));
                            return EnumActionResult.FAIL;
                        }
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        if (stack.func_77978_p().func_74764_b("tardis_id")) {
                            PlayerUtils.sendMessageToPlayer(player, TextFormatting.RED + "A Tardis is already bound to this key.");
                            data.setCurrentTardisPosition(MathUtils.blockPosToVec3(tet.func_174877_v()));
                        } else {
                            stack.func_77978_p().func_74768_a("tardis_id", data.getTardisID());
                            stack.func_151001_c(TextFormatting.YELLOW + "Tardis Key: (" + TextFormatting.RED + data.getTardisID() + TextFormatting.YELLOW + ")");
                            PlayerUtils.sendMessageToPlayer(player, TextFormatting.GREEN + "Tardis bound to key: " + TextFormatting.YELLOW + data.getTardisID());
                            data.setCurrentTardisPosition(MathUtils.blockPosToVec3(tet.func_174877_v()));
                        }
                        TardisSaveHandler.saveTardis(data);
                        return EnumActionResult.FAIL;
                    }
                }
            }
            if (world.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                PlayerUtils.sendMessageToPlayer(player, TextFormatting.RED + "Cannot summon Tardis in the Tardis");
                return EnumActionResult.FAIL;
            }
            if (world.func_180495_p(pos) != DMBlocks.TARDIS) {
                int TardisID = PersistantDataManager.getInt((Entity)player, "last_tardis_ID");
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tardis_id")) {
                    TardisID = stack.func_77978_p().func_74762_e("tardis_id");
                }
                if (DMTardis.doesTardisExist(TardisID) && (data = DMTardis.getTardis(TardisID)) != null) {
                    if (DMTardis.hasPermission(data, player)) {
                        if (data.isInFlight()) {
                            int DIMid = data.getTardisPreviousDimensionLocation();
                            BlockPos p = new BlockPos((Vec3i)WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()));
                            WorldServer world1 = player.field_70170_p.func_73046_m().func_71218_a(DIMid);
                            TileEntity tee = world1.func_175625_s(p);
                            if (tee == null) {
                                world1.func_175656_a(pos.func_177982_a(0, 1, 0), DMBlocks.TARDIS.func_176203_a(player.func_174811_aO().func_176734_d().func_176745_a()));
                                TileEntity te2 = world1.func_175625_s(pos.func_177982_a(0, 1, 0));
                                if (te2 instanceof TileEntityTardis) {
                                    TileEntityTardis tet2 = (TileEntityTardis)te2;
                                    tet2.tardisID = TardisID;
                                    tet2.setRemat(true);
                                    data.setPreviousTardisPosition(data.getCurrentTardisPosition());
                                    data.setTardisPreviousDimensionLocation(data.getTardisDimensionLocation());
                                    data.setPreviousLocationName(player.field_70170_p.func_73046_m().func_71218_a((int)data.getTardisDimensionLocation()).field_73011_w.func_186058_p().func_186065_b());
                                    data.setTardisDimensionLocation(world1.field_73011_w.getDimension());
                                    data.setCurrentLocationName(player.field_70170_p.func_73046_m().func_71218_a((int)world1.field_73011_w.getDimension()).field_73011_w.func_186058_p().func_186065_b());
                                    data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos.func_177982_a(0, 1, 0)));
                                    tet2.func_189515_b(new NBTTagCompound());
                                    for (Object player1 : world1.field_73010_i) {
                                        if (!(player1 instanceof EntityPlayer)) continue;
                                        ((EntityPlayerMP)player1).field_71135_a.func_147359_a((Packet)tet2.func_189518_D_());
                                    }
                                }
                                for (Object player1 : world1.field_73010_i) {
                                    DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)player1);
                                }
                                WorldUtils.markBlockForUpdate((World)world1, pos.func_177982_a(0, 1, 0));
                            } else {
                                PlayerUtils.sendMessageToPlayer(player, TextFormatting.RED + "Cannot summon Tardis whilst in flight");
                            }
                            return EnumActionResult.FAIL;
                        }
                        int DIMid = data.getTardisPreviousDimensionLocation();
                        BlockPos p = new BlockPos(data.getCurrentTardisPosition().x, data.getCurrentTardisPosition().y, data.getCurrentTardisPosition().z);
                        WorldServer world1 = player.field_70170_p.func_73046_m().func_71218_a(DIMid);
                        TileEntity tee = world1.func_175625_s(p);
                        if (tee != null && tee instanceof TileEntityTardis) {
                            TileEntityTardis tet = (TileEntityTardis)tee;
                            if (!(data.isInFlight() || tet.isDemat || tet.isRemat)) {
                                tet.setDemat(true);
                                data.setInFlight(true);
                                world1.func_175656_a(pos.func_177982_a(0, 1, 0), DMBlocks.TARDIS.func_176203_a(player.func_174811_aO().func_176734_d().func_176745_a()));
                                TileEntity te2 = world1.func_175625_s(pos.func_177982_a(0, 1, 0));
                                if (te2 instanceof TileEntityTardis) {
                                    TileEntityTardis tet2 = (TileEntityTardis)te2;
                                    tet2.tardisID = TardisID;
                                    tet2.setRemat(true);
                                    data.setPreviousTardisPosition(data.getCurrentTardisPosition());
                                    data.setTardisPreviousDimensionLocation(data.getTardisDimensionLocation());
                                    data.setPreviousLocationName(player.field_70170_p.func_73046_m().func_71218_a((int)data.getTardisDimensionLocation()).field_73011_w.func_186058_p().func_186065_b());
                                    data.setTardisDimensionLocation(world1.field_73011_w.getDimension());
                                    data.setCurrentLocationName(player.field_70170_p.func_73046_m().func_71218_a((int)world1.field_73011_w.getDimension()).field_73011_w.func_186058_p().func_186065_b());
                                    data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos.func_177982_a(0, 1, 0)));
                                    tet2.func_189515_b(new NBTTagCompound());
                                    for (Object player1 : world1.field_73010_i) {
                                        if (!(player1 instanceof EntityPlayer)) continue;
                                        ((EntityPlayerMP)player1).field_71135_a.func_147359_a((Packet)tet2.func_189518_D_());
                                    }
                                }
                                for (Object player1 : world1.field_73010_i) {
                                    DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)player1);
                                }
                                WorldUtils.markBlockForUpdate((World)world1, pos.func_177982_a(0, 1, 0));
                            } else {
                                PlayerUtils.sendMessageToPlayer(player, TextFormatting.RED + "Cannot summon Tardis whilst in flight");
                                return EnumActionResult.FAIL;
                            }
                        }
                        WorldUtils.markBlockForUpdate((World)world1, p);
                    } else {
                        PlayerUtils.sendMessageToPlayer(player, TextFormatting.RED + "This is not your TARDIS.");
                    }
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("\u00a75Used to: ");
        tooltip.add("\u00a75- Summon your TARDIS!");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

