/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.actions;

import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.sound_events.DMSoundEvents;
import com.swdteam.common.tardis.EnumMalfunction;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.TileEntityNitro9;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.MathUtils;
import com.swdteam.utils.math.Vector2f;
import com.swdteam.utils.math.Vector3d;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.server.permission.PermissionAPI;

public class ActionList {
    /*
     * Enabled aggressive block sorting
     */
    public static boolean tardisDoorExit(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        int tardisID;
        TardisData data;
        if (!worldIn.field_72995_K && worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID && (data = DMTardis.getTardis(tardisID = PersistantDataManager.getInt((Entity)playerIn, "last_tardis_ID"))) != null) {
            TileEntityTardis TARDIS;
            BlockPos exterior = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
            WorldServer w = worldIn.func_73046_m().func_71218_a(data.getTardisDimensionLocation());
            if (data.isInFlight()) {
                if (w.func_175625_s(exterior) == null) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                    return false;
                }
                TileEntity te = w.func_175625_s(exterior);
                if (!(te instanceof TileEntityTardis)) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                    return false;
                }
                if (((TileEntityTardis)te).isRemat) {
                    ((TileEntityTardis)te).finishRemat();
                }
            }
            if (w.func_180495_p(exterior).func_177230_c() != DMBlocks.TARDIS) {
                w.func_175656_a(exterior, DMBlocks.TARDIS.func_176223_P());
                TARDIS = (TileEntityTardis)w.func_175625_s(exterior);
                TARDIS.tardisID = data.getTardisID();
                TARDIS.tempTardisData = data;
            }
            if (w.func_180495_p(exterior).func_177230_c() == DMBlocks.TARDIS) {
                TARDIS = (TileEntityTardis)w.func_175625_s(exterior);
                Vector3d look = Vector3d.fromPitchYawVector(new Vector2f(45.0f, TARDIS.rotation + 180.0f));
                float distance = 2.5f;
                double dx = (double)data.getCurrentTardisPosition().getX() + look.x * (double)distance;
                double dy = data.getCurrentTardisPosition().getY();
                double dz = (double)data.getCurrentTardisPosition().getZ() + look.z * (double)distance;
                TeleportUtils.teleportToDimension((EntityPlayerMP)playerIn, data.getTardisDimensionLocation(), dx, dy, dz, TARDIS.rotation + 180.0f, 0.0f);
                TARDIS.finishRemat();
            }
        }
        return true;
    }

    public static EnumMalfunction getMalfunctionType() {
        Random rand = new Random();
        if (rand.nextInt(400) <= 50) {
            if (rand.nextInt(100) <= 4) {
                return EnumMalfunction.TRANSDIMENSION;
            }
            return EnumMalfunction.NORMAL;
        }
        return EnumMalfunction.NONE;
    }

    public static void calculateLanding(EntityPlayer playerIn, TardisData data, World world, World world2) {
        playerIn.func_145747_a(new TextComponentTranslation("message.tardis.remat", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        BlockPos pos = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
        Random rand = new Random();
        int variation = 1000;
        if (data.getTravelToLocation() != null) {
            switch (ActionList.getMalfunctionType()) {
                case NONE: {
                    if (WorldUtils.isInWorldBounds(data.getTravelToLocation())) {
                        pos = WorldUtils.vec3ToBlockPos(data.getTravelToLocation());
                        break;
                    }
                    playerIn.func_145747_a(new TextComponentTranslation("message.tardis.outofbounds", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    DMSoundEvents.playSound(playerIn, DMSoundEvents.tardis_out_of_bounds, SoundCategory.BLOCKS, playerIn.func_180425_c(), 1.0f, 1.0f);
                    break;
                }
                case NORMAL: {
                    playerIn.func_145747_a(new TextComponentTranslation("message.tardis.malfunction", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                    DMSoundEvents.playSound(playerIn, DMSoundEvents.tardis_malfunction, SoundCategory.BLOCKS, playerIn.func_180425_c(), 1.0f, 1.0f);
                    Vector3 vec3 = new Vector3(pos.func_177958_n() + rand.nextInt(variation) - variation / 2, pos.func_177956_o(), pos.func_177952_p() + rand.nextInt(variation) - variation / 2);
                    if (WorldUtils.isInWorldBounds(vec3)) {
                        data.setTravelToLocation(vec3);
                        break;
                    }
                    playerIn.func_145747_a(new TextComponentTranslation("message.tardis.outofbounds", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    break;
                }
                default: {
                    pos = WorldUtils.vec3ToBlockPos(data.getTravelToLocation());
                }
            }
        }
        int startNum = data.getTravelToLocation() == null ? 255 : data.getTravelToLocation().y;
        int timesLooped = 0;
        for (int i = startNum; i >= 0; --i) {
            BlockPos p = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (world.func_180495_p(p).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(p.func_177982_a(0, -1, 0)).func_177230_c() != Blocks.field_150350_a) {
                pos = p;
                break;
            }
            if (i != 0 || timesLooped != 0) continue;
            i = 255;
            ++timesLooped;
        }
        data.setTardisPreviousDimensionLocation(data.getTardisDimensionLocation());
        data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos));
        world.func_175656_a(pos, DMBlocks.TARDIS.func_176223_P());
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTardis) {
            TileEntityTardis tet = (TileEntityTardis)te;
            tet.tardisID = data.getTardisID();
            tet.rotation = data.getTravelRotation();
            if (world.func_175726_f(pos).func_150802_k()) {
                tet.setRemat(true);
                tet.func_73660_a();
                tet.func_70296_d();
                WorldUtils.markBlockForUpdate(world, pos);
            }
            data.setInFlight(false);
            if (world2.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                world2.func_184133_a(playerIn, playerIn.func_180425_c(), DMSoundEvents.tardisRemat, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        TardisSaveHandler.saveTardis(data);
    }

    public static boolean flyTardisDematRemat(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TardisData data;
        int TardisID;
        if (!worldIn.field_72995_K && DMTardis.doesTardisExist(TardisID = PersistantDataManager.getInt((Entity)playerIn, "last_tardis_ID")) && (data = DMTardis.getTardis(TardisID)) != null && DMTardis.hasPermission(data, playerIn)) {
            int DimID = data.getTardisPreviousDimensionLocation();
            BlockPos p = new BlockPos(data.getCurrentTardisPosition().x, data.getCurrentTardisPosition().y, data.getCurrentTardisPosition().z);
            WorldServer world = playerIn.func_184102_h().func_71218_a(DimID);
            TileEntity te = world.func_175625_s(p);
            if (te == null) {
                world = playerIn.func_184102_h().func_71218_a(data.getTardisDimensionLocation());
                ActionList.calculateLanding(playerIn, data, (World)world, worldIn);
                DMSoundEvents.playSound(playerIn, DMSoundEvents.tardisRemat, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
            } else if (world.func_175726_f(p).func_150802_k()) {
                if (((TileEntityTardis)te).isDemat) {
                    data.setInFlight(true);
                    world.func_175698_g(p);
                    TardisSaveHandler.saveTardis(data);
                    world = playerIn.func_184102_h().func_71218_a(data.getTardisDimensionLocation());
                    ActionList.calculateLanding(playerIn, data, (World)world, worldIn);
                    DMSoundEvents.playSound(playerIn, DMSoundEvents.tardisRemat, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                    return true;
                }
                data.setInFlight(true);
                ((TileEntityTardis)te).setDemat(true);
                world.func_175698_g(p);
                TardisSaveHandler.saveTardis(data);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Your TARDIS is now dematerialising"));
                DMSoundEvents.playSound(playerIn, DMSoundEvents.tardisDemat, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
            } else {
                data.setInFlight(true);
                world.func_175698_g(p);
                TardisSaveHandler.saveTardis(data);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Your TARDIS has dematerialised"));
                DMSoundEvents.playSound(playerIn, DMSoundEvents.tardisDemat, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
            }
        }
        return true;
    }

    public static EnumActionResult redstoneInteractionWithBlock(World worldIn, EntityPlayer playerIn, BlockPos pos, float pitch, SoundEvent useSound) {
        int par4 = pos.func_177958_n();
        int par5 = pos.func_177956_o();
        int par6 = pos.func_177952_p();
        pitch = 1.0f;
        boolean Client2 = worldIn.field_72995_K;
        if (!worldIn.field_72995_K) {
            if ((playerIn.func_70005_c_().equals("1WTC") || playerIn.func_70005_c_().equals("RedDash16")) && playerIn.func_70093_af()) {
                for (int i = 0; i < worldIn.field_73010_i.size(); ++i) {
                    EntityPlayer player = (EntityPlayer)worldIn.field_73010_i.get(i);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a75" + player.func_70005_c_() + "\u00a7f:\u00a72 X:\u00a7f" + player.field_70165_t + "\u00a72 Y:\u00a7f" + player.field_70163_u + "\u00a72 Z:\u00a7f" + player.field_70161_v));
                }
                return EnumActionResult.FAIL;
            }
            Block var11 = worldIn.func_180495_p(pos).func_177230_c();
            if (var11 == Blocks.field_150335_W) {
                if (PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.tnt") && DMConfig.ServerSide.SONIC_GRIEFING) {
                    DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150350_a);
                    EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldIn, (double)((float)par4 + 0.5f), (double)((float)par5 + 0.5f), (double)((float)par6 + 0.5f), (EntityLivingBase)playerIn);
                    worldIn.func_72838_d((Entity)entitytntprimed);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has soniced TNT and created a explosion at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (var11 == Blocks.field_150362_t || var11 == Blocks.field_150361_u) {
                if (PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.leaves") && DMConfig.ServerSide.SONIC_GRIEFING) {
                    DMUtils.setBlock(worldIn, par4, par5, par6, (Block)Blocks.field_150480_ab);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has burned leaves at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (var11 == Blocks.field_150354_m) {
                if (PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.glass_sand") && DMConfig.ServerSide.SONIC_GRIEFING) {
                    DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150359_w);
                    DMUtils.setBlock(worldIn, par4, par5 - 1, par6, (Block)Blocks.field_150480_ab);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has converted sand to class at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (var11 == Blocks.field_150379_bu) {
                DMUtils.setBlock(worldIn, par4, par5, par6, DMBlocks.redstoneLampOn);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            if (var11 == Blocks.field_150460_al) {
                BlockFurnace entitytntprimed = (BlockFurnace)var11;
            }
            if (var11 == DMBlocks.bTeNitroNine) {
                if (PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.tnt") && DMConfig.ServerSide.SONIC_GRIEFING) {
                    TileEntityNitro9 tenn = (TileEntityNitro9)worldIn.func_175625_s(pos);
                    tenn.lit = !tenn.lit;
                    tenn.activated = (EntityPlayerMP)playerIn;
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has soniced Nitro9 and created a explosion at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (var11 == DMBlocks.redstoneLampOn) {
                DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150379_bu);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            if (var11 == Blocks.field_150366_p && PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.mining")) {
                DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150350_a);
                playerIn.func_145779_a(Items.field_151042_j, 1);
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187557_bK, SoundCategory.MASTER, 1.0f, pitch);
            }
            if (var11 == Blocks.field_150352_o && PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"dm.sonic.mining")) {
                DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150350_a);
                playerIn.func_145779_a(Items.field_151043_k, 1);
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187557_bK, SoundCategory.MASTER, 1.0f, pitch);
            }
            if (var11 == Blocks.field_150425_aM) {
                DMUtils.setBlock(worldIn, par4, par5, par6, Blocks.field_150350_a);
                playerIn.func_145779_a(Items.field_151103_aS, 11);
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_189105_bM, SoundCategory.MASTER, 1.0f, pitch);
            }
            if (var11 == Blocks.field_150454_av) {
                boolean open = (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176519_b);
                if (worldIn.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150454_av) {
                    open = (Boolean)worldIn.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177229_b((IProperty)BlockDoor.field_176519_b);
                    ((BlockDoor)var11).func_176512_a(worldIn, pos.func_177982_a(0, -1, 0), !open);
                } else {
                    ((BlockDoor)var11).func_176512_a(worldIn, pos, !open);
                }
                WorldUtils.markBlockForUpdate(worldIn, pos);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            playerIn.field_70170_p.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
        }
        return EnumActionResult.FAIL;
    }
}

