/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.init.DMDamageSource;
import com.swdteam.common.init.DMLasers;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLaser
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private boolean isExplosive;
    private DamageSource damageSource = DMDamageSource.EXTERMINATED;
    private float damage = 10.0f;
    private int laser_id = 0;

    public EntityLaser(World worldIn) {
        super(worldIn);
    }

    public EntityLaser(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntityLaser(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public static void registerFixesLaser(DataFixer fixer) {
        EntityThrowable.func_189661_a((DataFixer)fixer, (String)"laser");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70142_S + (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70137_T + (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70136_U + (double)(this.field_70146_Z.nextFloat() / 4.0f), 1.0, 1.0, 1.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70142_S - (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70137_T - (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70136_U - (double)(this.field_70146_Z.nextFloat() / 4.0f), 1.0, 1.0, 1.0, new int[0]);
            }
        }
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    public void setExplosive(boolean isExplosive) {
        this.isExplosive = isExplosive;
    }

    public boolean isExplosive() {
        return this.isExplosive;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    protected void func_70184_a(RayTraceResult result) {
        int i;
        if (result.field_72308_g != null && result.field_72308_g != this.field_70192_c) {
            if (this.damageSource == null) {
                this.damageSource = DMDamageSource.LASER;
            }
            result.field_72308_g.func_70097_a(this.damageSource, this.damage);
        }
        if (this.isExplosive && result != null) {
            if (result.field_72308_g != null) {
                if (result.field_72308_g != this.field_70192_c) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true);
                }
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70142_S + (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70137_T + (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70136_U + (double)(this.field_70146_Z.nextFloat() / 4.0f), 1.0, 1.0, 1.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70142_S - (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70137_T - (double)(this.field_70146_Z.nextFloat() / 4.0f), this.field_70136_U - (double)(this.field_70146_Z.nextFloat() / 4.0f), 1.0, 1.0, 1.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && result != null) {
            if (result.field_72308_g != null) {
                if (result.field_72308_g != this.field_70192_c) {
                    if (this.field_70146_Z.nextInt(8) == 0) {
                        i = 1;
                        if (this.field_70146_Z.nextInt(32) == 0) {
                            i = 4;
                        }
                    }
                    this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                    this.func_70106_y();
                }
            } else {
                if (this.field_70146_Z.nextInt(8) == 0) {
                    i = 1;
                    if (this.field_70146_Z.nextInt(32) == 0) {
                        int n = 4;
                    }
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("laser_id", this.laser_id);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.laser_id = tagCompund.func_74762_e("laser_id");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.laser_id);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.laser_id = additionalData.readInt();
    }

    public int getLaserID() {
        return this.laser_id;
    }

    public void setLaser(DMLasers.Laser laser) {
        this.laser_id = DMLasers.getLaserID(laser);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70159_w *= (double)1.02f;
        this.field_70179_y *= (double)1.02f;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }
}

