/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.block.BlockTardis;
import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.entity.ai.AngelAttackMelee;
import com.swdteam.common.entity.ai.EntityAIFindEntityNearestPlayerEdited;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDamageSource;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSoundEvents;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TimeyWimeyDetector;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityWeepingAngel
extends EntityMob
implements IEntityAdditionalSpawnData {
    public ItemStack stolenKey;
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BREAKING_BLOCKS = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> CARRIED_ITEM = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> CAN_BE_SEEN = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    public float rotationOnSeen = 0.0f;
    private int block_break_time = 0;
    private int time_seen = 0;
    public int textureID = 0;
    public int Model = 0;

    public EntityWeepingAngel(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70178_ae = true;
        float moveSpeed = 0.2f;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(false);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AngelAttackMelee((EntityCreature)this, moveSpeed, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 9.5, DMItems.tardisKey, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindEntityNearestPlayerEdited((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.Model = 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CARRIED_ITEM, (Object)new ItemStack(Items.field_190931_a, 1, 0));
        this.func_184212_Q().func_187214_a(IS_BREAKING_BLOCKS, (Object)false);
        this.func_184212_Q().func_187214_a(IS_ANGRY, (Object)false);
        this.func_184212_Q().func_187214_a(CAN_BE_SEEN, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1000.0);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150348_b), this.func_70681_au().nextInt(3));
        if (this.getStolenKey() != null) {
            this.func_70099_a(this.getStolenKey(), 0.0f);
        }
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isBeingViewed()) {
            ++this.time_seen;
            if (this.time_seen > 11) {
                this.setBeingSeen(false);
                this.time_seen = 0;
            }
        }
        if (this.isBlockBreaking()) {
            ++this.block_break_time;
            if (this.block_break_time == 15) {
                this.setBreakingBlock(false);
                this.block_break_time = 0;
            }
        }
        if (this.isBeingViewed() && !this.isBlockBreaking() && this.func_70638_az() != null && this.field_70170_p.field_73012_v.nextInt(10) == 5) {
            this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)this.field_70146_Z.nextBoolean());
            this.func_184185_a(DMSoundEvents.Angel_Blink, 1.0f, 1.0f);
        }
        if (this.isBeingViewed()) {
            if (!this.field_70170_p.field_72995_K) {
                ++this.time_seen;
                if (this.time_seen > 5) {
                    this.setBeingSeen(false);
                    this.time_seen = 0;
                }
                if (this.field_70170_p.field_73012_v.nextInt(400) == 200) {
                    List<WorldUtils.BlockWithPos> blocks = WorldUtils.getBlocksWithinBounds(this.field_70170_p, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                    for (int i = 0; i < blocks.size(); ++i) {
                        WorldUtils.BlockWithPos block = blocks.get(i);
                        if (!DMConfig.Mobs.Angel_Light) continue;
                        if (block.getBlock() == Blocks.field_150374_bv) {
                            this.setAngry(false);
                            this.setBreakingBlock(true);
                            this.func_184185_a(DMSoundEvents.Angel_Lightbreak, 1.0f, 1.0f);
                            DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150379_bu);
                            this.func_70671_ap().func_75650_a((double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), 1.0f, 1.0f);
                            this.func_70671_ap().func_75649_a();
                            DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150379_bu);
                        }
                        if (block.getBlock() == DMBlocks.TARDIS) {
                            this.setAngry(true);
                        }
                        if (block.getBlock() == Blocks.field_150478_aa) {
                            this.setAngry(false);
                            this.setBreakingBlock(true);
                            this.func_184185_a(DMSoundEvents.Angel_Lightbreak, 1.0f, 1.0f);
                            DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                            this.func_70671_ap().func_75650_a((double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), 1.0f, 1.0f);
                            this.func_70671_ap().func_75649_a();
                            DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                        }
                        if (block.getBlock() == Blocks.field_150429_aA) {
                            this.func_70671_ap().func_75650_a((double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), 1.0f, 1.0f);
                            this.func_70671_ap().func_75649_a();
                            this.setAngry(false);
                            this.setBreakingBlock(true);
                            this.func_184185_a(DMSoundEvents.Angel_Lightbreak, 1.0f, 1.0f);
                            DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                        }
                        if (block.getBlock().func_149750_m(null) < 7 || block.getBlock() instanceof BlockTardis) continue;
                        this.func_70671_ap().func_75650_a((double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), 1.0f, 1.0f);
                        this.func_70671_ap().func_75649_a();
                        this.setAngry(false);
                        this.setBreakingBlock(true);
                        this.func_184185_a(DMSoundEvents.Angel_Lightbreak, 1.0f, 1.0f);
                        DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150350_a);
                        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), new ItemStack(block.getBlock(), 1, 0)));
                        break;
                    }
                }
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)2.2f);
        }
    }

    public void setAngry(boolean angry) {
        this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)angry);
    }

    public void setBreakingBlock(boolean breaking) {
        this.func_184212_Q().func_187227_b(IS_BREAKING_BLOCKS, (Object)breaking);
    }

    public void setBeingSeen(boolean canbeseen) {
        this.func_184212_Q().func_187227_b(CAN_BE_SEEN, (Object)canbeseen);
    }

    public boolean isAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ANGRY);
    }

    public boolean isBlockBreaking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BREAKING_BLOCKS);
    }

    public boolean isBeingViewed() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_BE_SEEN);
    }

    protected boolean func_70610_aX() {
        if (this.isBeingViewed()) {
            return true;
        }
        return super.func_70610_aX();
    }

    public List<EntityPlayer> getPlayers() {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
    }

    protected boolean isInFieldOfVision(EntityLiving e1, EntityPlayer e2) {
        boolean b;
        if (e2 == null) {
            return false;
        }
        Vec3d vec3 = e2.func_70040_Z();
        Vec3d vec31 = new Vec3d(this.field_70165_t - e2.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.field_70131_O - (e2.field_70163_u + (double)e2.func_70047_e()), this.field_70161_v - e2.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        boolean bl = b = d1 > 0.975 / d0;
        if ((b = b ? this.canEntityBeSeen((Entity)e2, (Entity)this) && e2.func_70660_b(MobEffects.field_76440_q) == null : false) && d0 > (double)0.1f) {
            return true;
        }
        return b;
    }

    public boolean canEntityBeSeen(Entity e1, Entity e2) {
        RayTraceResult mop = e1.field_70170_p.func_72933_a(new Vec3d(e1.field_70165_t, e1.field_70163_u + (double)e1.func_70047_e(), e1.field_70161_v), new Vec3d(e2.field_70165_t, e2.field_70163_u + (double)e2.func_70047_e(), e2.field_70161_v));
        if (mop == null) {
            return true;
        }
        Block b = this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c();
        return !b.func_149730_j(b.func_176223_P()) || !b.func_149686_d(b.func_176223_P());
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entity) {
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            boolean teleport = DMConfig.Mobs.Angel_Teleport;
            EntityPlayer e = (EntityPlayer)entity;
            if (this.field_70170_p.field_73012_v.nextInt(25) == 5 && e.func_130014_f_().field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                double x = this.field_70165_t + (double)this.field_70146_Z.nextInt(120);
                double y = this.field_70163_u + (double)this.field_70146_Z.nextInt(64);
                double z = this.field_70161_v + (double)this.field_70146_Z.nextInt(120);
                BlockPos p = new BlockPos(x, y, z);
                e.func_184595_k(x, y, z);
                PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_TimeyWimeyDetector(x, y, z, e.field_70170_p.field_73011_w.func_186058_p().func_186065_b()));
            }
        }
        super.func_82167_n(entity);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(DMDamageSource.WEEPINGANGEL, damageAmount);
    }

    public ItemStack getStolenKey() {
        return (ItemStack)this.func_184212_Q().func_187225_a(CARRIED_ITEM);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isBeingViewed()) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)entity;
            ep.func_70097_a(DMDamageSource.WEEPINGANGEL, 4.0f);
            if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() != DMItems.tardisKey && this.field_70146_Z.nextBoolean()) {
                for (int i = 0; i < ep.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = ep.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != DMItems.tardisKey) continue;
                    this.stolenKey = ep.field_71071_by.func_70301_a(i).func_77946_l();
                    ep.field_71071_by.func_70299_a(i, stack);
                    ep.field_71069_bz.func_75142_b();
                    if (this.field_70170_p.field_72995_K) continue;
                    ep.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "message.angel.key_taken", new Object[0]));
                    this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
                }
            }
            if (this.field_70146_Z.nextInt(3) == 2) {
                ep.func_70097_a(DMDamageSource.WEEPINGANGEL, 1.0f);
                if (ep.func_70660_b(MobEffects.field_76440_q) == null) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 50, 5));
                }
                if (ep.func_70660_b(MobEffects.field_76421_d) == null) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 18, 5));
                }
                if (ep.func_70660_b(MobEffects.field_76437_t) == null) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 18, 5));
                }
                if (ep.func_70660_b(MobEffects.field_76431_k) == null) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 18, 5));
                }
            }
        }
        return super.func_70652_k(entity);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() == DMItems.tardisKey) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getStolenKey().func_77955_b(tag);
            par1nbtTagCompound.func_74782_a("items", (NBTBase)tag);
        }
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        NBTTagCompound tag = par1nbtTagCompound.func_74775_l("items");
        this.stolenKey = new ItemStack(tag);
        this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
    }

    protected boolean teleportRandomly() {
        int amount = 64;
        if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() == DMItems.tardisKey) {
            amount = 10;
        }
        double d0 = this.field_70165_t + (double)this.field_70146_Z.nextInt(amount);
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(amount / 2);
        double d2 = this.field_70161_v + (double)this.field_70146_Z.nextInt(amount);
        this.teleportTo(d0, d1, d2);
        return true;
    }

    protected boolean teleportTo(double X, double Y, double Z) {
        BlockPos p = new BlockPos(X, Y, Z);
        if (this.field_70170_p.func_175623_d(p)) {
            if (this.field_70170_p.func_180495_p(p.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                this.func_70634_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            } else {
                for (int i = 1; i < 255; ++i) {
                    if (!this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                    this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
                }
            }
        } else {
            for (int i = 1; i < 255; ++i) {
                if (!this.field_70170_p.func_175623_d(p.func_177982_a(0, -p.func_177956_o() + i, 0)) || !this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
            }
        }
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.getStolenKey() != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getStolenKey());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            this.stolenKey = ByteBufUtils.readItemStack((ByteBuf)additionalData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

