/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.swdteam.common.entity.EntityTardis;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSoundEvents;
import com.swdteam.common.item.ItemSpaceSuit;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GravityEvent {
    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent e) {
        int Dimension2 = e.getEntity().field_70170_p.field_73011_w.getDimension();
        if (Dimension2 == DMConfig.DimensionIDs.Moon_Dimension_ID && e.getEntityLiving().func_184188_bt().isEmpty() && e.getEntity().field_70181_x > 0.0) {
            e.getEntity().field_70181_x = e.getEntity().field_70181_x * 8.0 * 0.5;
        }
    }

    @SubscribeEvent
    public void cancelPlayerFallDamage(LivingFallEvent e) {
        int Dimension2 = e.getEntity().field_70170_p.field_73011_w.getDimension();
        if (Dimension2 == DMConfig.DimensionIDs.Moon_Dimension_ID) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void LivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (PlayerUtils.Hands.isInEitherHand((EntityPlayer)player, DMItems.iToaster) && player.func_70090_H() && PlayerUtils.Hands.isInEitherHand((EntityPlayer)player, DMItems.iToaster) && player.func_70090_H()) {
                player.func_70606_j(0.0f);
            }
            if (player.func_184188_bt() != null && player.func_184188_bt().size() > 0 && player.func_184188_bt().get(0) instanceof EntityTardis) {
                EntityTardis tardis = (EntityTardis)((Object)player.func_184188_bt().get(0));
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
                if (!player.field_71075_bZ.field_75100_b) {
                    // empty if block
                }
                if (player.field_70122_E) {
                    if (player.field_71075_bZ.func_75094_b() > 0.0f) {
                        DMUtils.setWalkSpeed(player, 0.0f);
                        DMSoundEvents.playSound((EntityPlayer)player, DMSoundEvents.tardisLand, SoundCategory.BLOCKS, player.func_180425_c(), 1.0f, 1.0f);
                    }
                } else if (player.field_71075_bZ.func_75094_b() <= 0.0f) {
                    DMUtils.setWalkSpeed(player, 0.1f);
                }
            } else if (player.field_71075_bZ.func_75094_b() != 0.1f) {
                DMUtils.setWalkSpeed(player, 0.1f);
            }
        }
    }

    public float getRainDamage(EntityLivingBase l) {
        if (!l.field_70170_p.func_175678_i(l.func_180425_c())) {
            return 0.0f;
        }
        if (!(l instanceof EntityPlayer)) {
            return 1.0f;
        }
        ItemStack[] armour = new ItemStack[]{l.func_184582_a(EntityEquipmentSlot.CHEST), l.func_184582_a(EntityEquipmentSlot.HEAD), l.func_184582_a(EntityEquipmentSlot.FEET), l.func_184582_a(EntityEquipmentSlot.LEGS)};
        float f = 1.0f;
        for (int i = 0; i < armour.length; ++i) {
            if (armour[i] == null || !(armour[i].func_77973_b() instanceof ItemSpaceSuit)) continue;
            if (l.field_70170_p.field_73012_v.nextInt(250) == 150) {
                armour[i].func_77964_b(armour[i].func_77952_i() + 1);
            }
            f -= 0.25f;
        }
        return f;
    }

    public static enum GravityValues {
        EARTH(1.0f, 0),
        MOON(0.32f, DMConfig.DimensionIDs.Moon_Dimension_ID);

        private float g;
        private int[] dims;

        private GravityValues(float g, int ... dims) {
            this.g = g;
            this.dims = dims;
        }

        public float getG() {
            return this.g;
        }

        public int[] getDims() {
            return this.dims;
        }

        static GravityValues getGravityValueForDim(int dimID) {
            for (GravityValues gravity : GravityValues.values()) {
                for (int dim : gravity.dims) {
                    if (dim != dimID) continue;
                    return gravity;
                }
            }
            return EARTH;
        }
    }
}

