/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.swdteam.common.block.BlockDMTileEntityBase;
import com.swdteam.common.block.tardis.console_controls.IPanelControl;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockTardisFlightPanel
extends BlockDMTileEntityBase
implements IPanelControl {
    public BlockTardisFlightPanel(Supplier<TileEntity> tClass) {
        super(tClass);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                ITardisCapability capa = (ITardisCapability)playerIn.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                int TardisID = capa.getTARDISID();
                TardisData data = DMTardis.getTardis(TardisID);
                if (data != null) {
                    if (DMTardis.hasPermission(data, playerIn)) {
                        BlockPos ps;
                        WorldServer server = worldIn.func_73046_m().func_71218_a(data.getTardisDimensionLocation());
                        List<Block> l = WorldUtils.getBlocksForLandingWithinBounds((World)server, new AxisAlignedBB((double)((ps = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition())).func_177958_n() - 1), (double)ps.func_177956_o(), (double)(ps.func_177952_p() - 1), (double)(ps.func_177958_n() + 1), (double)(ps.func_177956_o() + 3), (double)(ps.func_177952_p() + 1)));
                        if (l.size() > 1) {
                            PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Not enough space to enter flight");
                            playerIn.field_70170_p.func_184134_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, DMSounds.tardis_malfunction, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                            return false;
                        }
                        if (playerIn.func_184187_bx() != null || playerIn.func_184218_aH()) {
                            return false;
                        }
                        if (!data.isInFlight()) {
                            double xPos = playerIn.field_70165_t;
                            double yPos = playerIn.field_70163_u;
                            double zPos = playerIn.field_70161_v;
                            float pitch = playerIn.field_70125_A;
                            float yaw = playerIn.field_70177_z;
                            capa.setTARDISPosX(xPos);
                            capa.setTARDISPosY(yPos);
                            capa.setTARDISPosZ(zPos);
                            capa.setTARDISID(TardisID);
                            capa.setPitch(pitch);
                            capa.setYaw(yaw);
                            capa.setInFlight(true);
                            WorldServer world_pos = worldIn.func_73046_m().func_71218_a(data.getTardisDimensionLocation());
                            TeleportUtils.teleportToDimensionFlightPanel(data, (EntityPlayerMP)playerIn, data.getTardisDimensionLocation(), data.getCurrentTardisPosition().x, data.getCurrentTardisPosition().y, data.getCurrentTardisPosition().z, 0.0f, 0.0f);
                            world_pos.func_175698_g(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()));
                            playerIn.func_70095_a(false);
                            if (!playerIn.field_71075_bZ.field_75101_c) {
                                playerIn.field_71075_bZ.field_75101_c = true;
                            }
                            playerIn.field_70160_al = false;
                            playerIn.func_70637_d(false);
                            playerIn.field_71075_bZ.field_75102_a = true;
                            playerIn.field_70181_x += 8.0;
                            playerIn.field_71075_bZ.field_75099_e = false;
                            playerIn.eyeHeight = 2.0f;
                            playerIn.func_71016_p();
                            data.setInFlight(true);
                            TardisSaveHandler.saveTardis(data);
                            capa.syncToPlayer();
                        } else {
                            PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Tardis already in flight");
                        }
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "You do not have permission");
                    }
                }
            } else {
                PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Can only be used in the Tardis");
            }
        }
        return true;
    }

    @Override
    public String getDesc() {
        return "Flight Panel";
    }
}

