/*
 * Decompiled with CFR 0.152.
 */
package me.sub.angels;

import com.swdteam.common.entity.EntityWeepingAngel;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class AngelUtils {
    public static void getAllAngels(EntityPlayer seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        Vec3d vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            AxisAlignedBB bb;
            List list;
            distanceTraveled += vec3.func_72433_c();
            if ((list = seeker.field_70170_p.func_72872_a(EntityWeepingAngel.class, bb = new AxisAlignedBB((targetX += vec3.field_72450_a) - radius, (targetY += vec3.field_72448_b) - radius, (targetZ += vec3.field_72449_c) - radius, targetX + radius, targetY + radius, targetZ + radius))).isEmpty()) continue;
            for (EntityWeepingAngel target : list) {
                if (!target.func_70067_L() || !AngelUtils.isTargetInSight((EntityLivingBase)seeker, (Entity)target) || seeker.func_70644_a(MobEffects.field_76440_q) || seeker.func_175149_v()) continue;
                target.setBeingSeen(true);
            }
        }
    }

    private static boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && AngelUtils.isInEyeLine((Entity)seeker, target, 60.0f);
    }

    private static boolean isInEyeLine(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (seeker.field_70177_z > 360.0f) {
            seeker.field_70177_z -= 360.0f;
        }
        while (seeker.field_70177_z < -360.0f) {
            seeker.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }
}

