/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.capability;

import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.MessageSyncFlightModeCap;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.utils.FileUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityTardis
implements ITardisCapability {
    @CapabilityInject(value=ITardisCapability.class)
    public static final Capability<ITardisCapability> FLIGHTMODE_CAP = null;
    public TardisData data = null;
    public EntityPlayer player;
    public boolean isInFlight;
    public boolean isOnGround;
    public boolean resetLogin;
    private int tardis_id;
    private double tardis_X;
    private double tardis_Y;
    private double tardis_Z;
    private float tardis_yaw;
    private float tardis_pitch;
    private int ticksOnGround;
    public float rotation = 0.0f;
    public boolean requestedSent = false;

    public CapabilityTardis(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("isInFlight", this.isInFlight);
        compound.func_74757_a("isOnGround", this.isOnGround);
        compound.func_74768_a("tardis_id", this.tardis_id);
        compound.func_74780_a("tardis_X", this.tardis_X);
        compound.func_74780_a("tardis_Y", this.tardis_Y);
        compound.func_74780_a("tardis_Z", this.tardis_Z);
        compound.func_74780_a("tardis_yaw", (double)this.tardis_yaw);
        compound.func_74780_a("tardis_pitch", (double)this.tardis_pitch);
        compound.func_74757_a("resetLogin", this.resetLogin);
        compound.func_74768_a("ticksOnGround", this.ticksOnGround);
        return compound;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.isInFlight = nbt.func_74767_n("isInFlight");
        this.isOnGround = nbt.func_74767_n("isOnGround");
        this.tardis_id = nbt.func_74762_e("tardis_id");
        this.tardis_X = nbt.func_74769_h("tardis_X");
        this.tardis_Y = nbt.func_74769_h("tardis_Y");
        this.tardis_Z = nbt.func_74769_h("tardis_Z");
        this.resetLogin = nbt.func_74767_n("resetLogin");
        this.tardis_yaw = nbt.func_74760_g("tardis_yaw");
        this.tardis_pitch = nbt.func_74760_g("tardis_pitch");
        this.ticksOnGround = nbt.func_74762_e("ticksOnground");
    }

    @Override
    public void syncToPlayer() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncFlightModeCap(this.player));
    }

    @Override
    public double getTARDISX() {
        return this.tardis_X;
    }

    @Override
    public double getTARDISY() {
        return this.tardis_Y;
    }

    @Override
    public double getTARDISZ() {
        return this.tardis_Z;
    }

    @Override
    public boolean getInFlight() {
        return this.isInFlight;
    }

    @Override
    public int getTARDISID() {
        return this.tardis_id;
    }

    @Override
    public void setTARDISID(int flight_mode_tid) {
        this.tardis_id = flight_mode_tid;
    }

    @Override
    public void setInFlight(boolean inFlight) {
        this.isInFlight = inFlight;
    }

    @Override
    public boolean getOnGround() {
        return this.isOnGround;
    }

    @Override
    public void setOnGround(boolean OnGround) {
        this.isOnGround = OnGround;
    }

    @Override
    public void setTARDISPosX(double X) {
        this.tardis_X = X;
    }

    @Override
    public void setTARDISPosY(double Y) {
        this.tardis_Y = Y;
    }

    @Override
    public void setTARDISPosZ(double Z) {
        this.tardis_Z = Z;
    }

    @Override
    public void setPitch(float pitch) {
        this.tardis_pitch = pitch;
    }

    @Override
    public void setYaw(float yaw) {
        this.tardis_yaw = yaw;
    }

    @Override
    public float getYaw() {
        return this.tardis_yaw;
    }

    @Override
    public float getPitch() {
        return this.tardis_pitch;
    }

    @Override
    public boolean getResetLogin() {
        return this.resetLogin;
    }

    @Override
    public void setResetLogin(boolean b) {
        this.resetLogin = b;
    }

    @Override
    public int getTicksOnground() {
        return this.ticksOnGround;
    }

    @Override
    public void setTicksOnground(int ticks) {
        this.ticksOnGround = ticks;
    }

    @Override
    public void setTardisData(TardisData data) {
        this.data = data;
    }

    @Override
    public TardisData getTardisData(boolean serverSide) {
        if (this.data == null || this.data != null && this.data == DMTardis.DEFAULT_DATA) {
            this.data = DMTardis.getTardis(serverSide, this.getTARDISID());
        }
        if (!this.requestedSent && !serverSide && this.data == null) {
            this.requestedSent = true;
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.getTARDISID()));
        }
        return this.data;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public static class Storage
    implements Capability.IStorage<ITardisCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<ITardisCapability> capability, ITardisCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ITardisCapability> capability, ITardisCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(FLIGHTMODE_CAP, null)) {
                return;
            }
            event.addCapability(FileUtils.newResourceLocation("thedalekmod:TARDIS"), (ICapabilityProvider)new CapabilityFlightModeProvider(new CapabilityTardis((EntityPlayer)event.getObject())));
        }

        @SubscribeEvent
        public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
            if (event.getTarget().hasCapability(FLIGHTMODE_CAP, null)) {
                ((ITardisCapability)event.getTarget().getCapability(FLIGHTMODE_CAP, null)).syncToPlayer();
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            NBTTagCompound nbt = (NBTTagCompound)FLIGHTMODE_CAP.getStorage().writeNBT(FLIGHTMODE_CAP, event.getOriginal().getCapability(FLIGHTMODE_CAP, null), null);
            FLIGHTMODE_CAP.getStorage().readNBT(FLIGHTMODE_CAP, event.getEntityPlayer().getCapability(FLIGHTMODE_CAP, null), null, (NBTBase)nbt);
        }
    }

    public static class CapabilityFlightModeProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private ITardisCapability capability;

        public CapabilityFlightModeProvider(ITardisCapability capability) {
            this.capability = capability;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return FLIGHTMODE_CAP != null && capability == FLIGHTMODE_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == FLIGHTMODE_CAP ? FLIGHTMODE_CAP.cast((Object)this.capability) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)FLIGHTMODE_CAP.getStorage().writeNBT(FLIGHTMODE_CAP, (Object)this.capability, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            FLIGHTMODE_CAP.getStorage().readNBT(FLIGHTMODE_CAP, (Object)this.capability, null, (NBTBase)nbt);
        }
    }
}

