/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.structures.trenzalore;

import com.swdteam.common.dimensions.world.WorldProviderTrenzalore;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.world.gen.structures.trenzalore.TrenzaloreWorldGenCobwebs;
import com.swdteam.common.world.gen.structures.trenzalore.WorldGenSpike;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class TrenzaloreWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        WorldProvider provider = world.field_73011_w;
        if (provider instanceof WorldProviderTrenzalore) {
            this.generateTrenzalore(world, random, chunkX, chunkZ, 12, 20, 128);
        }
    }

    private void generateTrenzalore(World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for TrenzaloreWorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int randOffsetX = rand.nextInt(16);
            int randOffsetZ = rand.nextInt(16);
            int x = chunk_X * 16;
            int y = rand.nextInt(128);
            BlockPos p = new BlockPos(x + randOffsetX, y, (z = chunk_Z * 16) + randOffsetX);
            if (world.func_180495_p(p).func_177230_c() != DMBlocks.Granite || world.func_180495_p(p.func_177982_a(0, 1, 0)).func_177230_c() != Blocks.field_150350_a) continue;
            if (rand.nextBoolean()) {
                WorldGenSpike.generate(world, rand, p.func_177982_a(-randOffsetX + 8, -10, -randOffsetZ + 8), DMBlocks.Granite.func_176223_P());
                if (rand.nextBoolean()) {
                    BlockPos pos = p.func_177982_a(-randOffsetX, 0, -randOffsetZ);
                    int xR = rand.nextInt(12);
                    int zR = rand.nextInt(12);
                    for (int j = 0; j < xR; ++j) {
                        for (int k = 0; k < zR; ++k) {
                            if ((k == zR - 1 || j == xR - 1) && rand.nextBoolean() || !world.func_190526_b(p.func_177958_n() + j, p.func_177952_p() + k) || world.func_180495_p(p.func_177982_a(j, 0, k)).func_177230_c() != DMBlocks.Granite) continue;
                            world.func_175656_a(p.func_177982_a(j, 0, k), Blocks.field_150356_k.func_176223_P());
                        }
                    }
                }
            } else {
                world.func_175656_a(p, Blocks.field_150356_k.func_176223_P());
            }
            new TrenzaloreWorldGenCobwebs();
        }
    }
}

