/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.swdteam.common.tardis.data.TardisData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleportUtils {
    public static void teleportToDimension(Entity player, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        Boolean e = TeleportUtils.teleportEntityDim(player, new BlockPos(xPos, yPos, zPos), dimension);
        if (e instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)e;
            p.field_71135_a.func_147364_a(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
        }
        player.func_70012_b(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
        player.func_184189_br();
        player.field_70170_p.func_72866_a(player, false);
    }

    public static void teleportToDimensionFlightPanel(TardisData data, EntityPlayerMP player, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        try {
            Entity e = TeleportUtils.teleportPlayerToDimension(player.field_71133_b, (Entity)player, dimension);
            if (e instanceof EntityPlayerMP) {
                EntityPlayerMP p = (EntityPlayerMP)e;
                p.field_71135_a.func_147364_a(xPos + 0.5, yPos + 1.0, zPos + 0.5, facing, pitch);
                p.field_71075_bZ.field_75100_b = true;
                p.field_71075_bZ.field_75099_e = false;
                p.field_71075_bZ.field_75101_c = true;
                p.field_71075_bZ.field_75102_a = true;
                p.func_70012_b(xPos + 0.5, yPos + 1.0, zPos + 0.5, facing, pitch);
                p.func_184189_br();
                p.func_71121_q().func_72866_a((Entity)p, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Entity teleportPlayerToDimension(MinecraftServer server, Entity entity, int dimension) {
        if (entity instanceof EntityPlayerMP) {
            server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, dimension, (Teleporter)new TeleporterSimple((WorldServer)server.func_130014_f_()));
            return entity;
        }
        return null;
    }

    public static boolean teleportEntityDim(Entity entity, BlockPos pos, int targetDim) {
        int from;
        if (entity.func_130014_f_().field_72995_K || entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_70089_S()) {
            return false;
        }
        EntityPlayerMP player = null;
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
        }
        if ((from = entity.field_71093_bK) != targetDim) {
            MinecraftServer server = player == null ? entity.func_184102_h() : player.field_71133_b;
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            TeleporterSimple teleporter = new TeleporterSimple(toDim);
            if (player != null) {
                server.func_184103_al().transferPlayerToDimension(player, targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                NBTTagCompound tagCompound = entity.serializeNBT();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                fromDim.func_72900_e(entity);
                Entity newEntity = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)toDim);
                if (newEntity != null) {
                    newEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                } else {
                    return false;
                }
            }
        }
        if (!entity.field_70170_p.func_175667_e(pos)) {
            entity.field_70170_p.func_175726_f(pos);
        }
        if (player != null && player.field_71135_a != null) {
            player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            player.func_82242_a(0);
        } else {
            entity.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
        }
        entity.field_70143_R = 0.0f;
        return true;
    }

    public static class TeleporterSimple
    extends Teleporter {
        public TeleporterSimple(WorldServer worldIn) {
            super(worldIn);
        }

        public void func_180266_a(Entity entity, float rotationYaw) {
        }

        public boolean func_180620_b(Entity entity, float float_for_something) {
            return true;
        }

        public boolean func_85188_a(Entity entity) {
            return true;
        }

        public void func_85189_a(long stale_long) {
        }
    }
}

