/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.tardis.console_controls;

import com.swdteam.client.model.mdl.MDLState;
import com.swdteam.common.block.BlockDMTileEntityBase;
import com.swdteam.common.block.tardis.console_controls.IPanelControl;
import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.sound_events.DMSoundEvents;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockTardisDoorControl
extends BlockDMTileEntityBase
implements IPanelControl {
    public BlockTardisDoorControl(Class<? extends TileEntity> tClass) {
        super(tClass);
    }

    @Override
    public String getDesc() {
        return "Door control";
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int TardisID;
        TardisData data;
        if (hand == EnumHand.MAIN_HAND && !worldIn.field_72995_K && worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID && (data = DMTardis.getTardis(TardisID = PersistantDataManager.getInt((Entity)playerIn, "last_tardis_ID"))) != null) {
            if (DMTardis.hasPermission(data, playerIn)) {
                if (data != null) {
                    if (data.isInFlight()) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot open the doors during flight"));
                        return true;
                    }
                    if (data.isLocked()) {
                        worldIn.func_184133_a(playerIn, pos, DMSoundEvents.DoorLocked, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "The Tardis doors are locked"));
                        return true;
                    }
                    WorldServer server = playerIn.func_184102_h().func_71218_a(data.getTardisDimensionLocation());
                    ChameleonCircuitBase skin = DMTardis.getTardisSkin(data.getExteriorID());
                    if (skin != null && skin.hasDoorRotation()) {
                        DMTileEntityBase tile = (DMTileEntityBase)worldIn.func_175625_s(pos);
                        tile.model_state = tile.model_state == MDLState.ACTIVE ? MDLState.DEFAULT : MDLState.ACTIVE;
                        if (tile != null) {
                            tile.func_70296_d();
                            tile.func_145831_w().func_184138_a(pos, state, state, this.field_149786_r);
                            WorldUtils.markBlockForUpdate(worldIn, pos);
                        }
                        if (data.isDoorOpen()) {
                            data.setDoorOpen(false);
                            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()), false), server.field_73011_w.getDimension());
                            DMSoundEvents.playSound((EntityPlayer)((EntityPlayerMP)playerIn), skin.doorSound(false), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Doors have been closed"));
                        } else {
                            data.setDoorOpen(true);
                            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Doors have been opened"));
                            DMSoundEvents.playSound((EntityPlayer)((EntityPlayerMP)playerIn), skin.doorSound(true), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()), true), server.field_73011_w.getDimension());
                        }
                    }
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This is not your Tardis"));
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitZ, hitZ, hitZ);
    }
}

